/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.observable.event.PubliclyAvailableInformation;
import cdm.observable.event.meta.CreditEventNoticeMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditEventNotice", builder=CreditEventNoticeBuilderImpl.class, version="5.28.0")
@RuneDataType(value="CreditEventNotice", model="cdm", builder=CreditEventNoticeBuilderImpl.class, version="5.28.0")
public interface CreditEventNotice
extends RosettaModelObject {
    public static final CreditEventNoticeMeta metaData = new CreditEventNoticeMeta();

    public List<CounterpartyRoleEnum> getNotifyingParty();

    public BusinessCenterEnum getBusinessCenter();

    public PubliclyAvailableInformation getPubliclyAvailableInformation();

    public CreditEventNotice build();

    public CreditEventNoticeBuilder toBuilder();

    public static CreditEventNoticeBuilder builder() {
        return new CreditEventNoticeBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditEventNotice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditEventNotice> getType() {
        return CreditEventNotice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("notifyingParty"), CounterpartyRoleEnum.class, this.getNotifyingParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("businessCenter"), BusinessCenterEnum.class, (Object)this.getBusinessCenter(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, PubliclyAvailableInformation.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
    }

    public static class CreditEventNoticeBuilderImpl
    implements CreditEventNoticeBuilder {
        protected List<CounterpartyRoleEnum> notifyingParty = new ArrayList<CounterpartyRoleEnum>();
        protected BusinessCenterEnum businessCenter;
        protected PubliclyAvailableInformation.PubliclyAvailableInformationBuilder publiclyAvailableInformation;

        @Override
        @RosettaAttribute(value="notifyingParty", isRequired=true)
        @RuneAttribute(value="notifyingParty", isRequired=true)
        public List<CounterpartyRoleEnum> getNotifyingParty() {
            return this.notifyingParty;
        }

        @Override
        @RosettaAttribute(value="businessCenter")
        @RuneAttribute(value="businessCenter")
        public BusinessCenterEnum getBusinessCenter() {
            return this.businessCenter;
        }

        @Override
        @RosettaAttribute(value="publiclyAvailableInformation")
        @RuneAttribute(value="publiclyAvailableInformation")
        public PubliclyAvailableInformation.PubliclyAvailableInformationBuilder getPubliclyAvailableInformation() {
            return this.publiclyAvailableInformation;
        }

        @Override
        public PubliclyAvailableInformation.PubliclyAvailableInformationBuilder getOrCreatePubliclyAvailableInformation() {
            PubliclyAvailableInformation.PubliclyAvailableInformationBuilder result = this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation : (this.publiclyAvailableInformation = PubliclyAvailableInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notifyingParty", isRequired=true)
        @RuneAttribute(value="notifyingParty", isRequired=true)
        public CreditEventNoticeBuilder addNotifyingParty(CounterpartyRoleEnum _notifyingParty) {
            if (_notifyingParty != null) {
                this.notifyingParty.add(_notifyingParty);
            }
            return this;
        }

        @Override
        public CreditEventNoticeBuilder addNotifyingParty(CounterpartyRoleEnum _notifyingParty, int idx) {
            this.getIndex(this.notifyingParty, idx, () -> _notifyingParty);
            return this;
        }

        @Override
        public CreditEventNoticeBuilder addNotifyingParty(List<CounterpartyRoleEnum> notifyingPartys) {
            if (notifyingPartys != null) {
                for (CounterpartyRoleEnum toAdd : notifyingPartys) {
                    this.notifyingParty.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notifyingParty")
        public CreditEventNoticeBuilder setNotifyingParty(List<CounterpartyRoleEnum> notifyingPartys) {
            this.notifyingParty = notifyingPartys == null ? new ArrayList<CounterpartyRoleEnum>() : (List)notifyingPartys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCenter")
        @RuneAttribute(value="businessCenter")
        public CreditEventNoticeBuilder setBusinessCenter(BusinessCenterEnum _businessCenter) {
            this.businessCenter = _businessCenter == null ? null : _businessCenter;
            return this;
        }

        @Override
        @RosettaAttribute(value="publiclyAvailableInformation")
        @RuneAttribute(value="publiclyAvailableInformation")
        public CreditEventNoticeBuilder setPubliclyAvailableInformation(PubliclyAvailableInformation _publiclyAvailableInformation) {
            this.publiclyAvailableInformation = _publiclyAvailableInformation == null ? null : _publiclyAvailableInformation.toBuilder();
            return this;
        }

        @Override
        public CreditEventNotice build() {
            return new CreditEventNoticeImpl(this);
        }

        @Override
        public CreditEventNoticeBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditEventNoticeBuilder prune() {
            if (this.publiclyAvailableInformation != null && !this.publiclyAvailableInformation.prune().hasData()) {
                this.publiclyAvailableInformation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getNotifyingParty() != null && !this.getNotifyingParty().isEmpty()) {
                return true;
            }
            if (this.getBusinessCenter() != null) {
                return true;
            }
            return this.getPubliclyAvailableInformation() != null && this.getPubliclyAvailableInformation().hasData();
        }

        public CreditEventNoticeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditEventNoticeBuilder o = (CreditEventNoticeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPubliclyAvailableInformation(), (RosettaModelObjectBuilder)o.getPubliclyAvailableInformation(), this::setPubliclyAvailableInformation);
            merger.mergeBasic(this.getNotifyingParty(), o.getNotifyingParty(), this::addNotifyingParty);
            merger.mergeBasic((Object)this.getBusinessCenter(), (Object)o.getBusinessCenter(), this::setBusinessCenter, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditEventNotice _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.notifyingParty, _that.getNotifyingParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.businessCenter, (Object)_that.getBusinessCenter())) {
                return false;
            }
            return Objects.equals(this.publiclyAvailableInformation, _that.getPubliclyAvailableInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notifyingParty != null ? this.notifyingParty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.businessCenter != null ? ((Object)((Object)this.businessCenter)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditEventNoticeBuilder {notifyingParty=" + this.notifyingParty + ", businessCenter=" + (Object)((Object)this.businessCenter) + ", publiclyAvailableInformation=" + this.publiclyAvailableInformation + '}';
        }
    }

    public static interface CreditEventNoticeBuilder
    extends CreditEventNotice,
    RosettaModelObjectBuilder {
        public PubliclyAvailableInformation.PubliclyAvailableInformationBuilder getOrCreatePubliclyAvailableInformation();

        @Override
        public PubliclyAvailableInformation.PubliclyAvailableInformationBuilder getPubliclyAvailableInformation();

        public CreditEventNoticeBuilder addNotifyingParty(CounterpartyRoleEnum var1);

        public CreditEventNoticeBuilder addNotifyingParty(CounterpartyRoleEnum var1, int var2);

        public CreditEventNoticeBuilder addNotifyingParty(List<CounterpartyRoleEnum> var1);

        public CreditEventNoticeBuilder setNotifyingParty(List<CounterpartyRoleEnum> var1);

        public CreditEventNoticeBuilder setBusinessCenter(BusinessCenterEnum var1);

        public CreditEventNoticeBuilder setPubliclyAvailableInformation(PubliclyAvailableInformation var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("notifyingParty"), CounterpartyRoleEnum.class, this.getNotifyingParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("businessCenter"), BusinessCenterEnum.class, (Object)this.getBusinessCenter(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, PubliclyAvailableInformation.PubliclyAvailableInformationBuilder.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
        }

        public CreditEventNoticeBuilder prune();
    }

    public static class CreditEventNoticeImpl
    implements CreditEventNotice {
        private final List<CounterpartyRoleEnum> notifyingParty;
        private final BusinessCenterEnum businessCenter;
        private final PubliclyAvailableInformation publiclyAvailableInformation;

        protected CreditEventNoticeImpl(CreditEventNoticeBuilder builder) {
            this.notifyingParty = Optional.ofNullable(builder.getNotifyingParty()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.businessCenter = builder.getBusinessCenter();
            this.publiclyAvailableInformation = Optional.ofNullable(builder.getPubliclyAvailableInformation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="notifyingParty", isRequired=true)
        @RuneAttribute(value="notifyingParty", isRequired=true)
        public List<CounterpartyRoleEnum> getNotifyingParty() {
            return this.notifyingParty;
        }

        @Override
        @RosettaAttribute(value="businessCenter")
        @RuneAttribute(value="businessCenter")
        public BusinessCenterEnum getBusinessCenter() {
            return this.businessCenter;
        }

        @Override
        @RosettaAttribute(value="publiclyAvailableInformation")
        @RuneAttribute(value="publiclyAvailableInformation")
        public PubliclyAvailableInformation getPubliclyAvailableInformation() {
            return this.publiclyAvailableInformation;
        }

        @Override
        public CreditEventNotice build() {
            return this;
        }

        @Override
        public CreditEventNoticeBuilder toBuilder() {
            CreditEventNoticeBuilder builder = CreditEventNotice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditEventNoticeBuilder builder) {
            Optional.ofNullable(this.getNotifyingParty()).ifPresent(builder::setNotifyingParty);
            Optional.ofNullable(this.getBusinessCenter()).ifPresent(builder::setBusinessCenter);
            Optional.ofNullable(this.getPubliclyAvailableInformation()).ifPresent(builder::setPubliclyAvailableInformation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditEventNotice _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.notifyingParty, _that.getNotifyingParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.businessCenter, (Object)_that.getBusinessCenter())) {
                return false;
            }
            return Objects.equals(this.publiclyAvailableInformation, _that.getPubliclyAvailableInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notifyingParty != null ? this.notifyingParty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.businessCenter != null ? ((Object)((Object)this.businessCenter)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditEventNotice {notifyingParty=" + this.notifyingParty + ", businessCenter=" + (Object)((Object)this.businessCenter) + ", publiclyAvailableInformation=" + this.publiclyAvailableInformation + '}';
        }
    }
}

