/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.fro;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="FloatingRateIndexStyleEnum")
public enum FloatingRateIndexStyleEnum {
    AVERAGE_FRO("AverageFRO", "Average FRO"),
    COMPOUNDED_FRO("CompoundedFRO", "Compounded FRO"),
    COMPOUNDED_INDEX("CompoundedIndex", "Compounded Index"),
    INDEX("Index", "Index"),
    OTHER("Other", "Other"),
    OVERNIGHT("Overnight", "Overnight Rate"),
    PUBLISHED_AVERAGE("PublishedAverage", "Published Average Rate"),
    SPECIFIED_FORMULA("SpecifiedFormula", "Specified Formula"),
    SWAP_RATE("SwapRate", "Swap Rate"),
    TERM_RATE("TermRate", "Term Rate");

    private static Map<String, FloatingRateIndexStyleEnum> values;
    private final String rosettaName;
    private final String displayName;

    private FloatingRateIndexStyleEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static FloatingRateIndexStyleEnum fromDisplayName(String name) {
        FloatingRateIndexStyleEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, FloatingRateIndexStyleEnum> map = new ConcurrentHashMap<String, FloatingRateIndexStyleEnum>();
        for (FloatingRateIndexStyleEnum instance : FloatingRateIndexStyleEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

