/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecisionRemoveTrailingZeros;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class RoundToPrecisionRemoveTrailingZerosImpl
extends RoundToPrecisionRemoveTrailingZeros {
    @Override
    protected BigDecimal doEvaluate(BigDecimal value, Integer precision, RoundingDirectionEnum roundingMode) {
        if (value == null) {
            return null;
        }
        if (precision == null || roundingMode == null) {
            return value;
        }
        return value.setScale((int)precision, this.toRoundingMode(roundingMode)).stripTrailingZeros();
    }

    private RoundingMode toRoundingMode(RoundingDirectionEnum roundingMode) {
        switch (roundingMode) {
            case UP: {
                return RoundingMode.UP;
            }
            case DOWN: {
                return RoundingMode.DOWN;
            }
            case NEAREST: {
                return RoundingMode.HALF_UP;
            }
        }
        throw new IllegalArgumentException("Unsupported RoundingDirectionEnum " + (Object)((Object)roundingMode));
    }
}

