# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['EquityAdditionalTerms']


class EquityAdditionalTerms(BaseDataClass):
  """
  Transaction AdditionalTerms that apply to Equity asset class.
  """
  extraordinaryEvents: Optional[ExtraordinaryEvents] = Field(None, description="")
  determinationTerms: List[DeterminationRolesAndTerms] = Field([], description="")
  @rosetta_condition
  def cardinality_determinationTerms(self):
    return check_cardinality(self.determinationTerms, 1, None)
  
  substitutionProvision: Optional[UnderlierSubstitutionProvision] = Field(None, description="")

from cdm.legaldocumentation.master.ExtraordinaryEvents import ExtraordinaryEvents
from cdm.legaldocumentation.master.DeterminationRolesAndTerms import DeterminationRolesAndTerms
from cdm.legaldocumentation.master.UnderlierSubstitutionProvision import UnderlierSubstitutionProvision

EquityAdditionalTerms.update_forward_refs()
