# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['CounterpartyPosition']

from cdm.event.position.ContractBase import ContractBase

class CounterpartyPosition(ContractBase):
  """
  A Position describes the accumulated effect of a set of securities or financial transactions.
  """
  positionIdentifier: List[PositionIdentifier] = Field([], description="Represents the identifier(s) that uniquely identify a position for an identity issuer. A position can include multiple identifiers, for example an internal position identifer and a UTI (Unique Trade Identifier).")
  """
  Represents the identifier(s) that uniquely identify a position for an identity issuer. A position can include multiple identifiers, for example an internal position identifer and a UTI (Unique Trade Identifier).
  """
  openDateTime: Optional[datetime] = Field(None, description="The date and time when the position was opened.")
  """
  The date and time when the position was opened.
  """
  tradeReference: List[AttributeWithReference | TradeState] = Field([], description="Reference to all the trades that constitute the position.")
  """
  Reference to all the trades that constitute the position.
  """
  party: List[Party] = Field([], description="The parties involved in the position, including the Clearing Organization.")
  """
  The parties involved in the position, including the Clearing Organization.
  """
  partyRole: List[PartyRole] = Field([], description="Represents the role each specified party takes in the position.")
  """
  Represents the role each specified party takes in the position.
  """
  positionBase: TradableProduct = Field(..., description="Encapsulates the core constituents that characterize a position.")
  """
  Encapsulates the core constituents that characterize a position.
  """

from cdm.event.common.PositionIdentifier import PositionIdentifier
from cdm.event.common.TradeState import TradeState
from cdm.base.staticdata.party.Party import Party
from cdm.base.staticdata.party.PartyRole import PartyRole
from cdm.product.template.TradableProduct import TradableProduct

CounterpartyPosition.update_forward_refs()
