# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['CounterpartyPositionState']


class CounterpartyPositionState(BaseDataClass):
  """
  Defines the fundamental financial information that can be changed by a Primitive Event and by extension any business or life-cycle event. Each PositionState specifies where a Position is in its life-cycle. PositionState is a root type and as such, can be created independently to any other CDM data type, but can also be used as part of the CDM Event Model.
  """
  counterpartyPosition: CounterpartyPosition = Field(..., description="Represents the Position that has been effected by a business or life-cycle event.")
  """
  Represents the Position that has been effected by a business or life-cycle event.
  """
  state: Optional[State] = Field(None, description="Represents the State of the Position through its life-cycle.")
  """
  Represents the State of the Position through its life-cycle.
  """
  observationHistory: List[ObservationEvent] = Field([], description="Represents the observed events related to a particular product or process, such as credit events or corporate actions.")
  """
  Represents the observed events related to a particular product or process, such as credit events or corporate actions.
  """
  valuationHistory: List[Valuation] = Field([], description="")

from cdm.event.position.CounterpartyPosition import CounterpartyPosition
from cdm.event.common.State import State
from cdm.event.common.ObservationEvent import ObservationEvent
from cdm.event.common.Valuation import Valuation

CounterpartyPositionState.update_forward_refs()
