/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.AssetPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="AssetPayoutQuantity")
@ImplementedBy(value=Default.class)
public interface AssetPayoutQuantity
extends Validator<AssetPayout> {
    public static final String NAME = "AssetPayoutQuantity";
    public static final String DEFINITION = "priceQuantity exists";

    public ValidationResult<AssetPayout> validate(RosettaPath var1, AssetPayout var2);

    public static class NoOp
    implements AssetPayoutQuantity {
        @Override
        public ValidationResult<AssetPayout> validate(RosettaPath path, AssetPayout assetPayout) {
            return ValidationResult.success((String)AssetPayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetPayout", (RosettaPath)path, (String)AssetPayoutQuantity.DEFINITION);
        }
    }

    public static class Default
    implements AssetPayoutQuantity {
        @Override
        public ValidationResult<AssetPayout> validate(RosettaPath path, AssetPayout assetPayout) {
            ComparisonResult result = this.executeDataRule(assetPayout);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)AssetPayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetPayout", (RosettaPath)path, (String)AssetPayoutQuantity.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition AssetPayoutQuantity failed.";
            }
            return ValidationResult.failure((String)AssetPayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetPayout", (RosettaPath)path, (String)AssetPayoutQuantity.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(AssetPayout assetPayout) {
            try {
                ComparisonResult result = ExpressionOperators.exists((Mapper)MapperS.of((Object)assetPayout).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

