/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.asset.AssetDeliveryInformation;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.Product;
import cdm.product.template.meta.ForwardPayoutMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ForwardPayout", builder=ForwardPayoutBuilderImpl.class, version="5.0.0")
public interface ForwardPayout
extends PayoutBase,
GlobalKey {
    public static final ForwardPayoutMeta metaData = new ForwardPayoutMeta();

    public Product getUnderlier();

    public String getDeliveryTerm();

    public AssetDeliveryInformation getDelivery();

    public CalculationSchedule getSchedule();

    public MetaFields getMeta();

    @Override
    public ForwardPayout build();

    @Override
    public ForwardPayoutBuilder toBuilder();

    public static ForwardPayoutBuilder builder() {
        return new ForwardPayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends ForwardPayout> metaData() {
        return metaData;
    }

    default public Class<? extends ForwardPayout> getType() {
        return ForwardPayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        PayoutBase.super.process(path, processor);
        processor.processBasic(path.newSubPath("deliveryTerm"), String.class, (Object)this.getDeliveryTerm(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlier"), processor, Product.class, this.getUnderlier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("delivery"), processor, AssetDeliveryInformation.class, this.getDelivery(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("schedule"), processor, CalculationSchedule.class, this.getSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class ForwardPayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements ForwardPayoutBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected Product.ProductBuilder underlier;
        protected String deliveryTerm;
        protected AssetDeliveryInformation.AssetDeliveryInformationBuilder delivery;
        protected CalculationSchedule.CalculationScheduleBuilder schedule;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="underlier")
        public Product.ProductBuilder getUnderlier() {
            return this.underlier;
        }

        @Override
        public Product.ProductBuilder getOrCreateUnderlier() {
            Product.ProductBuilder result = this.underlier != null ? this.underlier : (this.underlier = Product.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryTerm")
        public String getDeliveryTerm() {
            return this.deliveryTerm;
        }

        @Override
        @RosettaAttribute(value="delivery")
        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getDelivery() {
            return this.delivery;
        }

        @Override
        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getOrCreateDelivery() {
            AssetDeliveryInformation.AssetDeliveryInformationBuilder result = this.delivery != null ? this.delivery : (this.delivery = AssetDeliveryInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="schedule")
        public CalculationSchedule.CalculationScheduleBuilder getSchedule() {
            return this.schedule;
        }

        @Override
        public CalculationSchedule.CalculationScheduleBuilder getOrCreateSchedule() {
            CalculationSchedule.CalculationScheduleBuilder result = this.schedule != null ? this.schedule : (this.schedule = CalculationSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlier")
        public ForwardPayoutBuilder setUnderlier(Product underlier) {
            this.underlier = underlier == null ? null : underlier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryTerm")
        public ForwardPayoutBuilder setDeliveryTerm(String deliveryTerm) {
            this.deliveryTerm = deliveryTerm == null ? null : deliveryTerm;
            return this;
        }

        @Override
        @RosettaAttribute(value="delivery")
        public ForwardPayoutBuilder setDelivery(AssetDeliveryInformation delivery) {
            this.delivery = delivery == null ? null : delivery.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="schedule")
        public ForwardPayoutBuilder setSchedule(CalculationSchedule schedule) {
            this.schedule = schedule == null ? null : schedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        public ForwardPayoutBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiver")
        public ForwardPayoutBuilder setPayerReceiver(PayerReceiver payerReceiver) {
            this.payerReceiver = payerReceiver == null ? null : payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        public ForwardPayoutBuilder setPriceQuantity(ResolvablePriceQuantity priceQuantity) {
            this.priceQuantity = priceQuantity == null ? null : priceQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        public ForwardPayoutBuilder setPrincipalPayment(PrincipalPayments principalPayment) {
            this.principalPayment = principalPayment == null ? null : principalPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        public ForwardPayoutBuilder setSettlementTerms(SettlementTerms settlementTerms) {
            this.settlementTerms = settlementTerms == null ? null : settlementTerms.toBuilder();
            return this;
        }

        @Override
        public ForwardPayout build() {
            return new ForwardPayoutImpl(this);
        }

        @Override
        public ForwardPayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public ForwardPayoutBuilder prune() {
            super.prune();
            if (this.underlier != null && !this.underlier.prune().hasData()) {
                this.underlier = null;
            }
            if (this.delivery != null && !this.delivery.prune().hasData()) {
                this.delivery = null;
            }
            if (this.schedule != null && !this.schedule.prune().hasData()) {
                this.schedule = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getUnderlier() != null && this.getUnderlier().hasData()) {
                return true;
            }
            if (this.getDeliveryTerm() != null) {
                return true;
            }
            if (this.getDelivery() != null && this.getDelivery().hasData()) {
                return true;
            }
            return this.getSchedule() != null && this.getSchedule().hasData();
        }

        @Override
        public ForwardPayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ForwardPayoutBuilder o = (ForwardPayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlier(), (RosettaModelObjectBuilder)o.getUnderlier(), this::setUnderlier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDelivery(), (RosettaModelObjectBuilder)o.getDelivery(), this::setDelivery);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSchedule(), (RosettaModelObjectBuilder)o.getSchedule(), this::setSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getDeliveryTerm(), (Object)o.getDeliveryTerm(), this::setDeliveryTerm, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ForwardPayout _that = (ForwardPayout)this.getType().cast(o);
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!Objects.equals(this.deliveryTerm, _that.getDeliveryTerm())) {
                return false;
            }
            if (!Objects.equals(this.delivery, _that.getDelivery())) {
                return false;
            }
            if (!Objects.equals(this.schedule, _that.getSchedule())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.deliveryTerm != null ? this.deliveryTerm.hashCode() : 0);
            _result = 31 * _result + (this.delivery != null ? this.delivery.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ForwardPayoutBuilder {underlier=" + this.underlier + ", deliveryTerm=" + this.deliveryTerm + ", delivery=" + this.delivery + ", schedule=" + this.schedule + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static class ForwardPayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements ForwardPayout {
        private final Product underlier;
        private final String deliveryTerm;
        private final AssetDeliveryInformation delivery;
        private final CalculationSchedule schedule;
        private final MetaFields meta;

        protected ForwardPayoutImpl(ForwardPayoutBuilder builder) {
            super(builder);
            this.underlier = Optional.ofNullable(builder.getUnderlier()).map(f -> f.build()).orElse(null);
            this.deliveryTerm = builder.getDeliveryTerm();
            this.delivery = Optional.ofNullable(builder.getDelivery()).map(f -> f.build()).orElse(null);
            this.schedule = Optional.ofNullable(builder.getSchedule()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="underlier")
        public Product getUnderlier() {
            return this.underlier;
        }

        @Override
        @RosettaAttribute(value="deliveryTerm")
        public String getDeliveryTerm() {
            return this.deliveryTerm;
        }

        @Override
        @RosettaAttribute(value="delivery")
        public AssetDeliveryInformation getDelivery() {
            return this.delivery;
        }

        @Override
        @RosettaAttribute(value="schedule")
        public CalculationSchedule getSchedule() {
            return this.schedule;
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public ForwardPayout build() {
            return this;
        }

        @Override
        public ForwardPayoutBuilder toBuilder() {
            ForwardPayoutBuilder builder = ForwardPayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ForwardPayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getUnderlier()).ifPresent(builder::setUnderlier);
            Optional.ofNullable(this.getDeliveryTerm()).ifPresent(builder::setDeliveryTerm);
            Optional.ofNullable(this.getDelivery()).ifPresent(builder::setDelivery);
            Optional.ofNullable(this.getSchedule()).ifPresent(builder::setSchedule);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ForwardPayout _that = (ForwardPayout)this.getType().cast(o);
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!Objects.equals(this.deliveryTerm, _that.getDeliveryTerm())) {
                return false;
            }
            if (!Objects.equals(this.delivery, _that.getDelivery())) {
                return false;
            }
            if (!Objects.equals(this.schedule, _that.getSchedule())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.deliveryTerm != null ? this.deliveryTerm.hashCode() : 0);
            _result = 31 * _result + (this.delivery != null ? this.delivery.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ForwardPayout {underlier=" + this.underlier + ", deliveryTerm=" + this.deliveryTerm + ", delivery=" + this.delivery + ", schedule=" + this.schedule + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static interface ForwardPayoutBuilder
    extends ForwardPayout,
    PayoutBase.PayoutBaseBuilder,
    RosettaModelObjectBuilder {
        public Product.ProductBuilder getOrCreateUnderlier();

        @Override
        public Product.ProductBuilder getUnderlier();

        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getOrCreateDelivery();

        @Override
        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getDelivery();

        public CalculationSchedule.CalculationScheduleBuilder getOrCreateSchedule();

        @Override
        public CalculationSchedule.CalculationScheduleBuilder getSchedule();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public ForwardPayoutBuilder setUnderlier(Product var1);

        public ForwardPayoutBuilder setDeliveryTerm(String var1);

        public ForwardPayoutBuilder setDelivery(AssetDeliveryInformation var1);

        public ForwardPayoutBuilder setSchedule(CalculationSchedule var1);

        public ForwardPayoutBuilder setMeta(MetaFields var1);

        @Override
        public ForwardPayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public ForwardPayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public ForwardPayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public ForwardPayoutBuilder setSettlementTerms(SettlementTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            PayoutBase.PayoutBaseBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("deliveryTerm"), String.class, (Object)this.getDeliveryTerm(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlier"), processor, Product.ProductBuilder.class, this.getUnderlier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("delivery"), processor, AssetDeliveryInformation.AssetDeliveryInformationBuilder.class, this.getDelivery(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("schedule"), processor, CalculationSchedule.CalculationScheduleBuilder.class, this.getSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        @Override
        public ForwardPayoutBuilder prune();
    }
}

