/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="ScheduledTransferEnum")
public enum ScheduledTransferEnum {
    CORPORATE_ACTION("CorporateAction"),
    COUPON("Coupon"),
    CREDIT_EVENT("CreditEvent"),
    DIVIDEND_RETURN("DividendReturn"),
    EXERCISE("Exercise"),
    FIXED_RATE_RETURN("FixedRateReturn"),
    FLOATING_RATE_RETURN("FloatingRateReturn"),
    FRACTIONAL_AMOUNT("FractionalAmount"),
    INTEREST_RETURN("InterestReturn"),
    NET_INTEREST("NetInterest"),
    PERFORMANCE("Performance"),
    PRINCIPAL_PAYMENT("PrincipalPayment");

    private static Map<String, ScheduledTransferEnum> values;
    private final String rosettaName;
    private final String displayName;

    private ScheduledTransferEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private ScheduledTransferEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static ScheduledTransferEnum fromDisplayName(String name) {
        ScheduledTransferEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, ScheduledTransferEnum> map = new ConcurrentHashMap<String, ScheduledTransferEnum>();
        for (ScheduledTransferEnum instance : ScheduledTransferEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

