/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.Tranche;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

@RosettaDataRule(value="TrancheExhaustionPoint")
@ImplementedBy(value=Default.class)
public interface TrancheExhaustionPoint
extends Validator<Tranche> {
    public static final String NAME = "TrancheExhaustionPoint";
    public static final String DEFINITION = "exhaustionPoint >= 0.0 and exhaustionPoint <= 1.0";

    public ValidationResult<Tranche> validate(RosettaPath var1, Tranche var2);

    public static class NoOp
    implements TrancheExhaustionPoint {
        @Override
        public ValidationResult<Tranche> validate(RosettaPath path, Tranche tranche) {
            return ValidationResult.success((String)TrancheExhaustionPoint.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Tranche", (RosettaPath)path, (String)TrancheExhaustionPoint.DEFINITION);
        }
    }

    public static class Default
    implements TrancheExhaustionPoint {
        @Override
        public ValidationResult<Tranche> validate(RosettaPath path, Tranche tranche) {
            ComparisonResult result = this.executeDataRule(tranche);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TrancheExhaustionPoint.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Tranche", (RosettaPath)path, (String)TrancheExhaustionPoint.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TrancheExhaustionPoint failed.";
            }
            return ValidationResult.failure((String)TrancheExhaustionPoint.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Tranche", (RosettaPath)path, (String)TrancheExhaustionPoint.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Tranche tranche) {
            try {
                ComparisonResult result = ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)tranche).map("getExhaustionPoint", _tranche -> _tranche.getExhaustionPoint()), (Mapper)MapperS.of((Object)new BigDecimal("0.0")), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.lessThanEquals((Mapper)MapperS.of((Object)tranche).map("getExhaustionPoint", _tranche -> _tranche.getExhaustionPoint()), (Mapper)MapperS.of((Object)new BigDecimal("1.0")), (CardinalityOperator)CardinalityOperator.All));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

