/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="InterestRatePayoutCashSettlementTerms")
@ImplementedBy(value=Default.class)
public interface InterestRatePayoutCashSettlementTerms
extends Validator<InterestRatePayout> {
    public static final String NAME = "InterestRatePayoutCashSettlementTerms";
    public static final String DEFINITION = "if settlementTerms -> settlementCurrency exists and (settlementTerms -> settlementCurrency <> priceQuantity -> quantitySchedule -> unit -> currency or settlementTerms -> settlementCurrency <> priceQuantity -> quantityMultiplier -> fxLinkedNotionalSchedule -> varyingNotionalCurrency) then (settlementTerms -> cashSettlementTerms -> valuationMethod exists and settlementTerms -> cashSettlementTerms -> valuationDate exists) or priceQuantity -> quantityMultiplier -> fxLinkedNotionalSchedule -> fxSpotRateSource exists";

    public ValidationResult<InterestRatePayout> validate(RosettaPath var1, InterestRatePayout var2);

    public static class NoOp
    implements InterestRatePayoutCashSettlementTerms {
        @Override
        public ValidationResult<InterestRatePayout> validate(RosettaPath path, InterestRatePayout interestRatePayout) {
            return ValidationResult.success((String)InterestRatePayoutCashSettlementTerms.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InterestRatePayout", (RosettaPath)path, (String)InterestRatePayoutCashSettlementTerms.DEFINITION);
        }
    }

    public static class Default
    implements InterestRatePayoutCashSettlementTerms {
        @Override
        public ValidationResult<InterestRatePayout> validate(RosettaPath path, InterestRatePayout interestRatePayout) {
            ComparisonResult result = this.executeDataRule(interestRatePayout);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)InterestRatePayoutCashSettlementTerms.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InterestRatePayout", (RosettaPath)path, (String)InterestRatePayoutCashSettlementTerms.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition InterestRatePayoutCashSettlementTerms failed.";
            }
            return ValidationResult.failure((String)InterestRatePayoutCashSettlementTerms.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InterestRatePayout", (RosettaPath)path, (String)InterestRatePayoutCashSettlementTerms.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(InterestRatePayout interestRatePayout) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getSettlementTerms", payoutBase -> payoutBase.getSettlementTerms()).map("getSettlementCurrency", settlementBase -> settlementBase.getSettlementCurrency()).map("getValue", _f -> _f.getValue())).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)interestRatePayout).map("getSettlementTerms", payoutBase -> payoutBase.getSettlementTerms()).map("getSettlementCurrency", settlementBase -> settlementBase.getSettlementCurrency()).map("getValue", _f -> _f.getValue()), (Mapper)MapperS.of((Object)interestRatePayout).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("getValue", _f -> _f.getValue()).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()), (CardinalityOperator)CardinalityOperator.Any).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)interestRatePayout).map("getSettlementTerms", payoutBase -> payoutBase.getSettlementTerms()).map("getSettlementCurrency", settlementBase -> settlementBase.getSettlementCurrency()).map("getValue", _f -> _f.getValue()), (Mapper)MapperS.of((Object)interestRatePayout).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getQuantityMultiplier", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantityMultiplier()).map("getFxLinkedNotionalSchedule", quantityMultiplier -> quantityMultiplier.getFxLinkedNotionalSchedule()).map("getVaryingNotionalCurrency", fxLinkedNotionalSchedule -> fxLinkedNotionalSchedule.getVaryingNotionalCurrency()).map("getValue", _f -> _f.getValue()), (CardinalityOperator)CardinalityOperator.Any))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getSettlementTerms", payoutBase -> payoutBase.getSettlementTerms()).mapC("getCashSettlementTerms", settlementTerms -> settlementTerms.getCashSettlementTerms()).map("getValuationMethod", cashSettlementTerms -> cashSettlementTerms.getValuationMethod())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getSettlementTerms", payoutBase -> payoutBase.getSettlementTerms()).mapC("getCashSettlementTerms", settlementTerms -> settlementTerms.getCashSettlementTerms()).map("getValuationDate", cashSettlementTerms -> cashSettlementTerms.getValuationDate()))).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getQuantityMultiplier", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantityMultiplier()).map("getFxLinkedNotionalSchedule", quantityMultiplier -> quantityMultiplier.getFxLinkedNotionalSchedule()).map("getFxSpotRateSource", fxLinkedNotionalSchedule -> fxLinkedNotionalSchedule.getFxSpotRateSource())));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

