/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.processor;

import cdm.product.common.settlement.ResolvablePriceQuantity;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.stream.Collectors;

public class FeeLegMappingProcessor
extends MappingProcessor {
    public FeeLegMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        List<Mapping> legPriceQuantityMappings = this.filterMappingForModelPath(PathUtils.toPath((RosettaPath)this.getModelPath()));
        List<Mapping> legReferenceMappings = legPriceQuantityMappings.stream().filter(m -> m.getRosettaValue() instanceof Reference.ReferenceBuilder).collect(Collectors.toList());
        if (this.containsPathElement(legReferenceMappings, "feeLeg") && this.containsPathElement(legReferenceMappings, "protectionTerms")) {
            Path notionalPath = synonymPath.addElement("calculationAmount").addElement("amount");
            List notionalMappings = legPriceQuantityMappings.stream().filter(m -> m.getXmlPath().nameIndexMatches(notionalPath)).collect(Collectors.toList());
            this.getMappings().removeAll(notionalMappings);
            legPriceQuantityMappings.removeAll(notionalMappings);
            Path idPath = synonymPath.addElement("calculationAmount").addElement("id");
            List idMappings = legPriceQuantityMappings.stream().filter(m -> m.getXmlPath().nameIndexMatches(idPath)).collect(Collectors.toList());
            if (this.getMappings().removeAll(idMappings)) {
                ((ResolvablePriceQuantity.ResolvablePriceQuantityBuilder)builder).getOrCreateMeta().setExternalKey(null);
            }
            legPriceQuantityMappings.removeAll(idMappings);
            legPriceQuantityMappings.forEach(this::updateMappingSuccess);
        }
    }

    private List<Mapping> filterMappingForModelPath(Path modelPath) {
        return this.getMappings().stream().filter(m -> m.getRosettaPath() != null).filter(m -> modelPath.fullStartMatches(m.getRosettaPath())).collect(Collectors.toList());
    }

    private boolean containsPathElement(List<Mapping> referenceMappings, String pathElement) {
        return referenceMappings.stream().anyMatch(m -> m.getXmlPath().toString().contains(pathElement));
    }

    private void updateMappingSuccess(Mapping mapping) {
        mapping.setError(null);
        mapping.setCondition(true);
        mapping.setDuplicate(false);
    }
}

