/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.functions.AddBusinessDays;
import cdm.base.datetime.functions.GetAllBusinessCenters;
import cdm.product.common.schedule.ResetDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=DetermineFixingDateDefault.class)
public abstract class DetermineFixingDate
implements RosettaFunction {
    @Inject
    protected AddBusinessDays addBusinessDays;
    @Inject
    protected GetAllBusinessCenters getAllBusinessCenters;

    public Date evaluate(ResetDates resetDates, Date resetDate) {
        Date fixingDate = this.doEvaluate(resetDates, resetDate);
        return fixingDate;
    }

    protected abstract Date doEvaluate(ResetDates var1, Date var2);

    protected abstract Mapper<Integer> fixingOffsetDays(ResetDates var1, Date var2);

    protected abstract Mapper<BusinessCenterEnum> businessCenters(ResetDates var1, Date var2);

    protected abstract Mapper<Date> fixDate(ResetDates var1, Date var2);

    public static class DetermineFixingDateDefault
    extends DetermineFixingDate {
        @Override
        protected Date doEvaluate(ResetDates resetDates, Date resetDate) {
            Date fixingDate = null;
            return this.assignOutput(fixingDate, resetDates, resetDate);
        }

        protected Date assignOutput(Date fixingDate, ResetDates resetDates, Date resetDate) {
            fixingDate = (Date)MapperS.of((Object)((Date)this.fixDate(resetDates, resetDate).get())).get();
            return fixingDate;
        }

        @Override
        protected Mapper<Integer> fixingOffsetDays(ResetDates resetDates, Date resetDate) {
            return MapperS.of((Object)resetDates).map("getFixingDates", _resetDates -> _resetDates.getFixingDates()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier());
        }

        @Override
        protected Mapper<BusinessCenterEnum> businessCenters(ResetDates resetDates, Date resetDate) {
            return MapperC.of(this.getAllBusinessCenters.evaluate((BusinessCenters)MapperS.of((Object)resetDates).map("getFixingDates", _resetDates -> _resetDates.getFixingDates()).map("getBusinessCenters", relativeDateOffset -> relativeDateOffset.getBusinessCenters()).get()));
        }

        @Override
        protected Mapper<Date> fixDate(ResetDates resetDates, Date resetDate) {
            return MapperS.of((Object)this.addBusinessDays.evaluate((Date)MapperS.of((Object)resetDate).get(), (Integer)MapperS.of((Object)((Integer)this.fixingOffsetDays(resetDates, resetDate).get())).get(), MapperC.of((List)this.businessCenters(resetDates, resetDate).getMulti()).getMulti()));
        }
    }
}

