/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.ValuationSource;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;

@RosettaDataRule(value="ValuationSourceInformationSource")
@ImplementedBy(value=Default.class)
public interface ValuationSourceInformationSource
extends Validator<ValuationSource> {
    public static final String NAME = "ValuationSourceInformationSource";
    public static final String DEFINITION = "required choice informationSource, settlementRateOption, referenceBanks, dealerOrCCP";

    public ValidationResult<ValuationSource> validate(RosettaPath var1, ValuationSource var2);

    public static class NoOp
    implements ValuationSourceInformationSource {
        @Override
        public ValidationResult<ValuationSource> validate(RosettaPath path, ValuationSource valuationSource) {
            return ValidationResult.success((String)ValuationSourceInformationSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationSource", (RosettaPath)path, (String)ValuationSourceInformationSource.DEFINITION);
        }
    }

    public static class Default
    implements ValuationSourceInformationSource {
        @Override
        public ValidationResult<ValuationSource> validate(RosettaPath path, ValuationSource valuationSource) {
            ComparisonResult result = this.executeDataRule(valuationSource);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ValuationSourceInformationSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationSource", (RosettaPath)path, (String)ValuationSourceInformationSource.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ValuationSourceInformationSource failed.";
            }
            return ValidationResult.failure((String)ValuationSourceInformationSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationSource", (RosettaPath)path, (String)ValuationSourceInformationSource.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(ValuationSource valuationSource) {
            try {
                ComparisonResult result = ExpressionOperators.choice((Mapper)MapperS.of((Object)valuationSource), Arrays.asList("informationSource", "settlementRateOption", "referenceBanks", "dealerOrCCP"), (ValidationResult.ChoiceRuleValidationMethod)ValidationResult.ChoiceRuleValidationMethod.REQUIRED);
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

