/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.DatedValue;
import cdm.base.math.MeasureSchedule;
import cdm.base.math.UnitType;
import cdm.observable.asset.CashPrice;
import cdm.observable.asset.PriceComposite;
import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.meta.PriceScheduleMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PriceSchedule", builder=PriceScheduleBuilderImpl.class, version="5.0.0")
public interface PriceSchedule
extends MeasureSchedule {
    public static final PriceScheduleMeta metaData = new PriceScheduleMeta();

    public UnitType getPerUnitOf();

    public PriceTypeEnum getPriceType();

    public PriceExpressionEnum getPriceExpression();

    public PriceComposite getComposite();

    public ArithmeticOperationEnum getArithmeticOperator();

    public CashPrice getCashPrice();

    @Override
    public PriceSchedule build();

    @Override
    public PriceScheduleBuilder toBuilder();

    public static PriceScheduleBuilder builder() {
        return new PriceScheduleBuilderImpl();
    }

    default public RosettaMetaData<? extends PriceSchedule> metaData() {
        return metaData;
    }

    default public Class<? extends PriceSchedule> getType() {
        return PriceSchedule.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        MeasureSchedule.super.process(path, processor);
        processor.processBasic(path.newSubPath("priceType"), PriceTypeEnum.class, (Object)this.getPriceType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceExpression"), PriceExpressionEnum.class, (Object)this.getPriceExpression(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("arithmeticOperator"), ArithmeticOperationEnum.class, (Object)this.getArithmeticOperator(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("perUnitOf"), processor, UnitType.class, this.getPerUnitOf(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("composite"), processor, PriceComposite.class, this.getComposite(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashPrice"), processor, CashPrice.class, this.getCashPrice(), new AttributeMeta[0]);
    }

    public static class PriceScheduleBuilderImpl
    extends MeasureSchedule.MeasureScheduleBuilderImpl
    implements PriceScheduleBuilder {
        protected UnitType.UnitTypeBuilder perUnitOf;
        protected PriceTypeEnum priceType;
        protected PriceExpressionEnum priceExpression;
        protected PriceComposite.PriceCompositeBuilder composite;
        protected ArithmeticOperationEnum arithmeticOperator;
        protected CashPrice.CashPriceBuilder cashPrice;

        @Override
        @RosettaAttribute(value="perUnitOf")
        public UnitType.UnitTypeBuilder getPerUnitOf() {
            return this.perUnitOf;
        }

        @Override
        public UnitType.UnitTypeBuilder getOrCreatePerUnitOf() {
            UnitType.UnitTypeBuilder result = this.perUnitOf != null ? this.perUnitOf : (this.perUnitOf = UnitType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceType")
        public PriceTypeEnum getPriceType() {
            return this.priceType;
        }

        @Override
        @RosettaAttribute(value="priceExpression")
        public PriceExpressionEnum getPriceExpression() {
            return this.priceExpression;
        }

        @Override
        @RosettaAttribute(value="composite")
        public PriceComposite.PriceCompositeBuilder getComposite() {
            return this.composite;
        }

        @Override
        public PriceComposite.PriceCompositeBuilder getOrCreateComposite() {
            PriceComposite.PriceCompositeBuilder result = this.composite != null ? this.composite : (this.composite = PriceComposite.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="arithmeticOperator")
        public ArithmeticOperationEnum getArithmeticOperator() {
            return this.arithmeticOperator;
        }

        @Override
        @RosettaAttribute(value="cashPrice")
        public CashPrice.CashPriceBuilder getCashPrice() {
            return this.cashPrice;
        }

        @Override
        public CashPrice.CashPriceBuilder getOrCreateCashPrice() {
            CashPrice.CashPriceBuilder result = this.cashPrice != null ? this.cashPrice : (this.cashPrice = CashPrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="perUnitOf")
        public PriceScheduleBuilder setPerUnitOf(UnitType perUnitOf) {
            this.perUnitOf = perUnitOf == null ? null : perUnitOf.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceType")
        public PriceScheduleBuilder setPriceType(PriceTypeEnum priceType) {
            this.priceType = priceType == null ? null : priceType;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceExpression")
        public PriceScheduleBuilder setPriceExpression(PriceExpressionEnum priceExpression) {
            this.priceExpression = priceExpression == null ? null : priceExpression;
            return this;
        }

        @Override
        @RosettaAttribute(value="composite")
        public PriceScheduleBuilder setComposite(PriceComposite composite) {
            this.composite = composite == null ? null : composite.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="arithmeticOperator")
        public PriceScheduleBuilder setArithmeticOperator(ArithmeticOperationEnum arithmeticOperator) {
            this.arithmeticOperator = arithmeticOperator == null ? null : arithmeticOperator;
            return this;
        }

        @Override
        @RosettaAttribute(value="cashPrice")
        public PriceScheduleBuilder setCashPrice(CashPrice cashPrice) {
            this.cashPrice = cashPrice == null ? null : cashPrice.toBuilder();
            return this;
        }

        @Override
        public PriceScheduleBuilder addDatedValue(DatedValue datedValue) {
            if (datedValue != null) {
                this.datedValue.add(datedValue.toBuilder());
            }
            return this;
        }

        @Override
        public PriceScheduleBuilder addDatedValue(DatedValue datedValue, int _idx) {
            this.getIndex(this.datedValue, _idx, () -> datedValue.toBuilder());
            return this;
        }

        @Override
        public PriceScheduleBuilder addDatedValue(List<? extends DatedValue> datedValues) {
            if (datedValues != null) {
                for (DatedValue datedValue : datedValues) {
                    this.datedValue.add(datedValue.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="datedValue")
        public PriceScheduleBuilder setDatedValue(List<? extends DatedValue> datedValues) {
            this.datedValue = datedValues == null ? new ArrayList() : (List)datedValues.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="value")
        public PriceScheduleBuilder setValue(BigDecimal value) {
            this.value = value == null ? null : value;
            return this;
        }

        @Override
        @RosettaAttribute(value="unit")
        public PriceScheduleBuilder setUnit(UnitType unit) {
            this.unit = unit == null ? null : unit.toBuilder();
            return this;
        }

        @Override
        public PriceSchedule build() {
            return new PriceScheduleImpl(this);
        }

        @Override
        public PriceScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public PriceScheduleBuilder prune() {
            super.prune();
            if (this.perUnitOf != null && !this.perUnitOf.prune().hasData()) {
                this.perUnitOf = null;
            }
            if (this.composite != null && !this.composite.prune().hasData()) {
                this.composite = null;
            }
            if (this.cashPrice != null && !this.cashPrice.prune().hasData()) {
                this.cashPrice = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPerUnitOf() != null && this.getPerUnitOf().hasData()) {
                return true;
            }
            if (this.getPriceType() != null) {
                return true;
            }
            if (this.getPriceExpression() != null) {
                return true;
            }
            if (this.getComposite() != null && this.getComposite().hasData()) {
                return true;
            }
            if (this.getArithmeticOperator() != null) {
                return true;
            }
            return this.getCashPrice() != null && this.getCashPrice().hasData();
        }

        @Override
        public PriceScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PriceScheduleBuilder o = (PriceScheduleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPerUnitOf(), (RosettaModelObjectBuilder)o.getPerUnitOf(), this::setPerUnitOf);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getComposite(), (RosettaModelObjectBuilder)o.getComposite(), this::setComposite);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashPrice(), (RosettaModelObjectBuilder)o.getCashPrice(), this::setCashPrice);
            merger.mergeBasic((Object)this.getPriceType(), (Object)o.getPriceType(), this::setPriceType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceExpression(), (Object)o.getPriceExpression(), this::setPriceExpression, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getArithmeticOperator(), (Object)o.getArithmeticOperator(), this::setArithmeticOperator, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PriceSchedule _that = (PriceSchedule)this.getType().cast(o);
            if (!Objects.equals(this.perUnitOf, _that.getPerUnitOf())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceType, (Object)_that.getPriceType())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceExpression, (Object)_that.getPriceExpression())) {
                return false;
            }
            if (!Objects.equals(this.composite, _that.getComposite())) {
                return false;
            }
            if (!Objects.equals((Object)this.arithmeticOperator, (Object)_that.getArithmeticOperator())) {
                return false;
            }
            return Objects.equals(this.cashPrice, _that.getCashPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.perUnitOf != null ? this.perUnitOf.hashCode() : 0);
            _result = 31 * _result + (this.priceType != null ? ((Object)((Object)this.priceType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceExpression != null ? ((Object)((Object)this.priceExpression)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.composite != null ? this.composite.hashCode() : 0);
            _result = 31 * _result + (this.arithmeticOperator != null ? ((Object)((Object)this.arithmeticOperator)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cashPrice != null ? this.cashPrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PriceScheduleBuilder {perUnitOf=" + this.perUnitOf + ", priceType=" + (Object)((Object)this.priceType) + ", priceExpression=" + (Object)((Object)this.priceExpression) + ", composite=" + this.composite + ", arithmeticOperator=" + (Object)((Object)this.arithmeticOperator) + ", cashPrice=" + this.cashPrice + '}' + " " + super.toString();
        }
    }

    public static class PriceScheduleImpl
    extends MeasureSchedule.MeasureScheduleImpl
    implements PriceSchedule {
        private final UnitType perUnitOf;
        private final PriceTypeEnum priceType;
        private final PriceExpressionEnum priceExpression;
        private final PriceComposite composite;
        private final ArithmeticOperationEnum arithmeticOperator;
        private final CashPrice cashPrice;

        protected PriceScheduleImpl(PriceScheduleBuilder builder) {
            super(builder);
            this.perUnitOf = Optional.ofNullable(builder.getPerUnitOf()).map(f -> f.build()).orElse(null);
            this.priceType = builder.getPriceType();
            this.priceExpression = builder.getPriceExpression();
            this.composite = Optional.ofNullable(builder.getComposite()).map(f -> f.build()).orElse(null);
            this.arithmeticOperator = builder.getArithmeticOperator();
            this.cashPrice = Optional.ofNullable(builder.getCashPrice()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="perUnitOf")
        public UnitType getPerUnitOf() {
            return this.perUnitOf;
        }

        @Override
        @RosettaAttribute(value="priceType")
        public PriceTypeEnum getPriceType() {
            return this.priceType;
        }

        @Override
        @RosettaAttribute(value="priceExpression")
        public PriceExpressionEnum getPriceExpression() {
            return this.priceExpression;
        }

        @Override
        @RosettaAttribute(value="composite")
        public PriceComposite getComposite() {
            return this.composite;
        }

        @Override
        @RosettaAttribute(value="arithmeticOperator")
        public ArithmeticOperationEnum getArithmeticOperator() {
            return this.arithmeticOperator;
        }

        @Override
        @RosettaAttribute(value="cashPrice")
        public CashPrice getCashPrice() {
            return this.cashPrice;
        }

        @Override
        public PriceSchedule build() {
            return this;
        }

        @Override
        public PriceScheduleBuilder toBuilder() {
            PriceScheduleBuilder builder = PriceSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PriceScheduleBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPerUnitOf()).ifPresent(builder::setPerUnitOf);
            Optional.ofNullable(this.getPriceType()).ifPresent(builder::setPriceType);
            Optional.ofNullable(this.getPriceExpression()).ifPresent(builder::setPriceExpression);
            Optional.ofNullable(this.getComposite()).ifPresent(builder::setComposite);
            Optional.ofNullable(this.getArithmeticOperator()).ifPresent(builder::setArithmeticOperator);
            Optional.ofNullable(this.getCashPrice()).ifPresent(builder::setCashPrice);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PriceSchedule _that = (PriceSchedule)this.getType().cast(o);
            if (!Objects.equals(this.perUnitOf, _that.getPerUnitOf())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceType, (Object)_that.getPriceType())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceExpression, (Object)_that.getPriceExpression())) {
                return false;
            }
            if (!Objects.equals(this.composite, _that.getComposite())) {
                return false;
            }
            if (!Objects.equals((Object)this.arithmeticOperator, (Object)_that.getArithmeticOperator())) {
                return false;
            }
            return Objects.equals(this.cashPrice, _that.getCashPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.perUnitOf != null ? this.perUnitOf.hashCode() : 0);
            _result = 31 * _result + (this.priceType != null ? ((Object)((Object)this.priceType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceExpression != null ? ((Object)((Object)this.priceExpression)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.composite != null ? this.composite.hashCode() : 0);
            _result = 31 * _result + (this.arithmeticOperator != null ? ((Object)((Object)this.arithmeticOperator)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cashPrice != null ? this.cashPrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PriceSchedule {perUnitOf=" + this.perUnitOf + ", priceType=" + (Object)((Object)this.priceType) + ", priceExpression=" + (Object)((Object)this.priceExpression) + ", composite=" + this.composite + ", arithmeticOperator=" + (Object)((Object)this.arithmeticOperator) + ", cashPrice=" + this.cashPrice + '}' + " " + super.toString();
        }
    }

    public static interface PriceScheduleBuilder
    extends PriceSchedule,
    MeasureSchedule.MeasureScheduleBuilder,
    RosettaModelObjectBuilder {
        public UnitType.UnitTypeBuilder getOrCreatePerUnitOf();

        @Override
        public UnitType.UnitTypeBuilder getPerUnitOf();

        public PriceComposite.PriceCompositeBuilder getOrCreateComposite();

        @Override
        public PriceComposite.PriceCompositeBuilder getComposite();

        public CashPrice.CashPriceBuilder getOrCreateCashPrice();

        @Override
        public CashPrice.CashPriceBuilder getCashPrice();

        public PriceScheduleBuilder setPerUnitOf(UnitType var1);

        public PriceScheduleBuilder setPriceType(PriceTypeEnum var1);

        public PriceScheduleBuilder setPriceExpression(PriceExpressionEnum var1);

        public PriceScheduleBuilder setComposite(PriceComposite var1);

        public PriceScheduleBuilder setArithmeticOperator(ArithmeticOperationEnum var1);

        public PriceScheduleBuilder setCashPrice(CashPrice var1);

        @Override
        public PriceScheduleBuilder addDatedValue(DatedValue var1);

        @Override
        public PriceScheduleBuilder addDatedValue(DatedValue var1, int var2);

        @Override
        public PriceScheduleBuilder addDatedValue(List<? extends DatedValue> var1);

        @Override
        public PriceScheduleBuilder setDatedValue(List<? extends DatedValue> var1);

        @Override
        public PriceScheduleBuilder setValue(BigDecimal var1);

        @Override
        public PriceScheduleBuilder setUnit(UnitType var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            MeasureSchedule.MeasureScheduleBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("priceType"), PriceTypeEnum.class, (Object)this.getPriceType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceExpression"), PriceExpressionEnum.class, (Object)this.getPriceExpression(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("arithmeticOperator"), ArithmeticOperationEnum.class, (Object)this.getArithmeticOperator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("perUnitOf"), processor, UnitType.UnitTypeBuilder.class, this.getPerUnitOf(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("composite"), processor, PriceComposite.PriceCompositeBuilder.class, this.getComposite(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashPrice"), processor, CashPrice.CashPriceBuilder.class, this.getCashPrice(), new AttributeMeta[0]);
        }

        @Override
        public PriceScheduleBuilder prune();
    }
}

