/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.QuoteBasisEnum;
import cdm.observable.asset.QuotedCurrencyPair;
import cdm.observable.asset.meta.CrossRateMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CrossRate", builder=CrossRateBuilderImpl.class, version="5.0.0")
public interface CrossRate
extends QuotedCurrencyPair {
    public static final CrossRateMeta metaData = new CrossRateMeta();

    public BigDecimal getRate();

    public BigDecimal getSpotRate();

    public BigDecimal getForwardPoints();

    @Override
    public CrossRate build();

    @Override
    public CrossRateBuilder toBuilder();

    public static CrossRateBuilder builder() {
        return new CrossRateBuilderImpl();
    }

    default public RosettaMetaData<? extends CrossRate> metaData() {
        return metaData;
    }

    default public Class<? extends CrossRate> getType() {
        return CrossRate.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        QuotedCurrencyPair.super.process(path, processor);
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("forwardPoints"), BigDecimal.class, (Object)this.getForwardPoints(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CrossRateBuilderImpl
    extends QuotedCurrencyPair.QuotedCurrencyPairBuilderImpl
    implements CrossRateBuilder {
        protected BigDecimal rate;
        protected BigDecimal spotRate;
        protected BigDecimal forwardPoints;

        @Override
        @RosettaAttribute(value="rate")
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="forwardPoints")
        public BigDecimal getForwardPoints() {
            return this.forwardPoints;
        }

        @Override
        @RosettaAttribute(value="rate")
        public CrossRateBuilder setRate(BigDecimal rate) {
            this.rate = rate == null ? null : rate;
            return this;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        public CrossRateBuilder setSpotRate(BigDecimal spotRate) {
            this.spotRate = spotRate == null ? null : spotRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="forwardPoints")
        public CrossRateBuilder setForwardPoints(BigDecimal forwardPoints) {
            this.forwardPoints = forwardPoints == null ? null : forwardPoints;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency1")
        public CrossRateBuilder setCurrency1(FieldWithMetaString currency1) {
            this.currency1 = currency1 == null ? null : currency1.toBuilder();
            return this;
        }

        @Override
        public CrossRateBuilder setCurrency1Value(String currency1) {
            this.getOrCreateCurrency1().setValue(currency1);
            return this;
        }

        @Override
        @RosettaAttribute(value="currency2")
        public CrossRateBuilder setCurrency2(FieldWithMetaString currency2) {
            this.currency2 = currency2 == null ? null : currency2.toBuilder();
            return this;
        }

        @Override
        public CrossRateBuilder setCurrency2Value(String currency2) {
            this.getOrCreateCurrency2().setValue(currency2);
            return this;
        }

        @Override
        @RosettaAttribute(value="quoteBasis")
        public CrossRateBuilder setQuoteBasis(QuoteBasisEnum quoteBasis) {
            this.quoteBasis = quoteBasis == null ? null : quoteBasis;
            return this;
        }

        @Override
        public CrossRate build() {
            return new CrossRateImpl(this);
        }

        @Override
        public CrossRateBuilder toBuilder() {
            return this;
        }

        @Override
        public CrossRateBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getRate() != null) {
                return true;
            }
            if (this.getSpotRate() != null) {
                return true;
            }
            return this.getForwardPoints() != null;
        }

        @Override
        public CrossRateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CrossRateBuilder o = (CrossRateBuilder)other;
            merger.mergeBasic((Object)this.getRate(), (Object)o.getRate(), this::setRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpotRate(), (Object)o.getSpotRate(), this::setSpotRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getForwardPoints(), (Object)o.getForwardPoints(), this::setForwardPoints, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CrossRate _that = (CrossRate)this.getType().cast(o);
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            return Objects.equals(this.forwardPoints, _that.getForwardPoints());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.forwardPoints != null ? this.forwardPoints.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CrossRateBuilder {rate=" + this.rate + ", spotRate=" + this.spotRate + ", forwardPoints=" + this.forwardPoints + '}' + " " + super.toString();
        }
    }

    public static class CrossRateImpl
    extends QuotedCurrencyPair.QuotedCurrencyPairImpl
    implements CrossRate {
        private final BigDecimal rate;
        private final BigDecimal spotRate;
        private final BigDecimal forwardPoints;

        protected CrossRateImpl(CrossRateBuilder builder) {
            super(builder);
            this.rate = builder.getRate();
            this.spotRate = builder.getSpotRate();
            this.forwardPoints = builder.getForwardPoints();
        }

        @Override
        @RosettaAttribute(value="rate")
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="forwardPoints")
        public BigDecimal getForwardPoints() {
            return this.forwardPoints;
        }

        @Override
        public CrossRate build() {
            return this;
        }

        @Override
        public CrossRateBuilder toBuilder() {
            CrossRateBuilder builder = CrossRate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CrossRateBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRate()).ifPresent(builder::setRate);
            Optional.ofNullable(this.getSpotRate()).ifPresent(builder::setSpotRate);
            Optional.ofNullable(this.getForwardPoints()).ifPresent(builder::setForwardPoints);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CrossRate _that = (CrossRate)this.getType().cast(o);
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            return Objects.equals(this.forwardPoints, _that.getForwardPoints());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.forwardPoints != null ? this.forwardPoints.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CrossRate {rate=" + this.rate + ", spotRate=" + this.spotRate + ", forwardPoints=" + this.forwardPoints + '}' + " " + super.toString();
        }
    }

    public static interface CrossRateBuilder
    extends CrossRate,
    QuotedCurrencyPair.QuotedCurrencyPairBuilder,
    RosettaModelObjectBuilder {
        public CrossRateBuilder setRate(BigDecimal var1);

        public CrossRateBuilder setSpotRate(BigDecimal var1);

        public CrossRateBuilder setForwardPoints(BigDecimal var1);

        @Override
        public CrossRateBuilder setCurrency1(FieldWithMetaString var1);

        @Override
        public CrossRateBuilder setCurrency1Value(String var1);

        @Override
        public CrossRateBuilder setCurrency2(FieldWithMetaString var1);

        @Override
        public CrossRateBuilder setCurrency2Value(String var1);

        @Override
        public CrossRateBuilder setQuoteBasis(QuoteBasisEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            QuotedCurrencyPair.QuotedCurrencyPairBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("forwardPoints"), BigDecimal.class, (Object)this.getForwardPoints(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CrossRateBuilder prune();
    }
}

