/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.master;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.legaldocumentation.master.MasterAgreementClauseIdentifierEnum;
import cdm.legaldocumentation.master.MasterAgreementClauseVariant;
import cdm.legaldocumentation.master.meta.MasterAgreementClauseMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MasterAgreementClause", builder=MasterAgreementClauseBuilderImpl.class, version="5.0.0")
public interface MasterAgreementClause
extends RosettaModelObject {
    public static final MasterAgreementClauseMeta metaData = new MasterAgreementClauseMeta();

    public MasterAgreementClauseIdentifierEnum getIdentifer();

    public String getName();

    public List<CounterpartyRoleEnum> getCounterparty();

    public List<PartyRoleEnum> getOtherParty();

    public List<? extends MasterAgreementClauseVariant> getVariant();

    public MasterAgreementClause build();

    public MasterAgreementClauseBuilder toBuilder();

    public static MasterAgreementClauseBuilder builder() {
        return new MasterAgreementClauseBuilderImpl();
    }

    default public RosettaMetaData<? extends MasterAgreementClause> metaData() {
        return metaData;
    }

    default public Class<? extends MasterAgreementClause> getType() {
        return MasterAgreementClause.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("identifer"), MasterAgreementClauseIdentifierEnum.class, (Object)this.getIdentifer(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty"), CounterpartyRoleEnum.class, this.getCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherParty"), PartyRoleEnum.class, this.getOtherParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("variant"), processor, MasterAgreementClauseVariant.class, this.getVariant(), new AttributeMeta[0]);
    }

    public static class MasterAgreementClauseBuilderImpl
    implements MasterAgreementClauseBuilder {
        protected MasterAgreementClauseIdentifierEnum identifer;
        protected String name;
        protected List<CounterpartyRoleEnum> counterparty = new ArrayList<CounterpartyRoleEnum>();
        protected List<PartyRoleEnum> otherParty = new ArrayList<PartyRoleEnum>();
        protected List<MasterAgreementClauseVariant.MasterAgreementClauseVariantBuilder> variant = new ArrayList<MasterAgreementClauseVariant.MasterAgreementClauseVariantBuilder>();

        @Override
        @RosettaAttribute(value="identifer")
        public MasterAgreementClauseIdentifierEnum getIdentifer() {
            return this.identifer;
        }

        @Override
        @RosettaAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="counterparty")
        public List<CounterpartyRoleEnum> getCounterparty() {
            return this.counterparty;
        }

        @Override
        @RosettaAttribute(value="otherParty")
        public List<PartyRoleEnum> getOtherParty() {
            return this.otherParty;
        }

        @Override
        @RosettaAttribute(value="variant")
        public List<? extends MasterAgreementClauseVariant.MasterAgreementClauseVariantBuilder> getVariant() {
            return this.variant;
        }

        @Override
        public MasterAgreementClauseVariant.MasterAgreementClauseVariantBuilder getOrCreateVariant(int _index) {
            if (this.variant == null) {
                this.variant = new ArrayList<MasterAgreementClauseVariant.MasterAgreementClauseVariantBuilder>();
            }
            return (MasterAgreementClauseVariant.MasterAgreementClauseVariantBuilder)this.getIndex(this.variant, _index, () -> {
                MasterAgreementClauseVariant.MasterAgreementClauseVariantBuilder newVariant = MasterAgreementClauseVariant.builder();
                return newVariant;
            });
        }

        @Override
        @RosettaAttribute(value="identifer")
        public MasterAgreementClauseBuilder setIdentifer(MasterAgreementClauseIdentifierEnum identifer) {
            this.identifer = identifer == null ? null : identifer;
            return this;
        }

        @Override
        @RosettaAttribute(value="name")
        public MasterAgreementClauseBuilder setName(String name) {
            this.name = name == null ? null : name;
            return this;
        }

        @Override
        public MasterAgreementClauseBuilder addCounterparty(CounterpartyRoleEnum counterparty) {
            if (counterparty != null) {
                this.counterparty.add(counterparty);
            }
            return this;
        }

        @Override
        public MasterAgreementClauseBuilder addCounterparty(CounterpartyRoleEnum counterparty, int _idx) {
            this.getIndex(this.counterparty, _idx, () -> counterparty);
            return this;
        }

        @Override
        public MasterAgreementClauseBuilder addCounterparty(List<? extends CounterpartyRoleEnum> counterpartys) {
            if (counterpartys != null) {
                for (CounterpartyRoleEnum counterpartyRoleEnum : counterpartys) {
                    this.counterparty.add(counterpartyRoleEnum);
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty")
        public MasterAgreementClauseBuilder setCounterparty(List<? extends CounterpartyRoleEnum> counterpartys) {
            this.counterparty = counterpartys == null ? new ArrayList<CounterpartyRoleEnum>() : (List)counterpartys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MasterAgreementClauseBuilder addOtherParty(PartyRoleEnum otherParty) {
            if (otherParty != null) {
                this.otherParty.add(otherParty);
            }
            return this;
        }

        @Override
        public MasterAgreementClauseBuilder addOtherParty(PartyRoleEnum otherParty, int _idx) {
            this.getIndex(this.otherParty, _idx, () -> otherParty);
            return this;
        }

        @Override
        public MasterAgreementClauseBuilder addOtherParty(List<? extends PartyRoleEnum> otherPartys) {
            if (otherPartys != null) {
                for (PartyRoleEnum partyRoleEnum : otherPartys) {
                    this.otherParty.add(partyRoleEnum);
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="otherParty")
        public MasterAgreementClauseBuilder setOtherParty(List<? extends PartyRoleEnum> otherPartys) {
            this.otherParty = otherPartys == null ? new ArrayList<PartyRoleEnum>() : (List)otherPartys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MasterAgreementClauseBuilder addVariant(MasterAgreementClauseVariant variant) {
            if (variant != null) {
                this.variant.add(variant.toBuilder());
            }
            return this;
        }

        @Override
        public MasterAgreementClauseBuilder addVariant(MasterAgreementClauseVariant variant, int _idx) {
            this.getIndex(this.variant, _idx, () -> variant.toBuilder());
            return this;
        }

        @Override
        public MasterAgreementClauseBuilder addVariant(List<? extends MasterAgreementClauseVariant> variants) {
            if (variants != null) {
                for (MasterAgreementClauseVariant masterAgreementClauseVariant : variants) {
                    this.variant.add(masterAgreementClauseVariant.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="variant")
        public MasterAgreementClauseBuilder setVariant(List<? extends MasterAgreementClauseVariant> variants) {
            this.variant = variants == null ? new ArrayList<MasterAgreementClauseVariant.MasterAgreementClauseVariantBuilder>() : (List)variants.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MasterAgreementClause build() {
            return new MasterAgreementClauseImpl(this);
        }

        @Override
        public MasterAgreementClauseBuilder toBuilder() {
            return this;
        }

        @Override
        public MasterAgreementClauseBuilder prune() {
            this.variant = this.variant.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getIdentifer() != null) {
                return true;
            }
            if (this.getName() != null) {
                return true;
            }
            if (this.getCounterparty() != null && !this.getCounterparty().isEmpty()) {
                return true;
            }
            if (this.getOtherParty() != null && !this.getOtherParty().isEmpty()) {
                return true;
            }
            return this.getVariant() != null && this.getVariant().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public MasterAgreementClauseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MasterAgreementClauseBuilder o = (MasterAgreementClauseBuilder)other;
            merger.mergeRosetta(this.getVariant(), o.getVariant(), this::getOrCreateVariant);
            merger.mergeBasic((Object)this.getIdentifer(), (Object)o.getIdentifer(), this::setIdentifer, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            merger.mergeBasic(this.getCounterparty(), o.getCounterparty(), this::addCounterparty);
            merger.mergeBasic(this.getOtherParty(), o.getOtherParty(), this::addOtherParty);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MasterAgreementClause _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.identifer, (Object)_that.getIdentifer())) {
                return false;
            }
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherParty, _that.getOtherParty())) {
                return false;
            }
            return ListEquals.listEquals(this.variant, _that.getVariant());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifer != null ? ((Object)((Object)this.identifer)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.otherParty != null ? this.otherParty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.variant != null ? this.variant.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MasterAgreementClauseBuilder {identifer=" + (Object)((Object)this.identifer) + ", name=" + this.name + ", counterparty=" + this.counterparty + ", otherParty=" + this.otherParty + ", variant=" + this.variant + '}';
        }
    }

    public static class MasterAgreementClauseImpl
    implements MasterAgreementClause {
        private final MasterAgreementClauseIdentifierEnum identifer;
        private final String name;
        private final List<CounterpartyRoleEnum> counterparty;
        private final List<PartyRoleEnum> otherParty;
        private final List<? extends MasterAgreementClauseVariant> variant;

        protected MasterAgreementClauseImpl(MasterAgreementClauseBuilder builder) {
            this.identifer = builder.getIdentifer();
            this.name = builder.getName();
            this.counterparty = Optional.ofNullable(builder.getCounterparty()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.otherParty = Optional.ofNullable(builder.getOtherParty()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.variant = Optional.ofNullable(builder.getVariant()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="identifer")
        public MasterAgreementClauseIdentifierEnum getIdentifer() {
            return this.identifer;
        }

        @Override
        @RosettaAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="counterparty")
        public List<CounterpartyRoleEnum> getCounterparty() {
            return this.counterparty;
        }

        @Override
        @RosettaAttribute(value="otherParty")
        public List<PartyRoleEnum> getOtherParty() {
            return this.otherParty;
        }

        @Override
        @RosettaAttribute(value="variant")
        public List<? extends MasterAgreementClauseVariant> getVariant() {
            return this.variant;
        }

        @Override
        public MasterAgreementClause build() {
            return this;
        }

        @Override
        public MasterAgreementClauseBuilder toBuilder() {
            MasterAgreementClauseBuilder builder = MasterAgreementClause.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MasterAgreementClauseBuilder builder) {
            Optional.ofNullable(this.getIdentifer()).ifPresent(builder::setIdentifer);
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getCounterparty()).ifPresent(builder::setCounterparty);
            Optional.ofNullable(this.getOtherParty()).ifPresent(builder::setOtherParty);
            Optional.ofNullable(this.getVariant()).ifPresent(builder::setVariant);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MasterAgreementClause _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.identifer, (Object)_that.getIdentifer())) {
                return false;
            }
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherParty, _that.getOtherParty())) {
                return false;
            }
            return ListEquals.listEquals(this.variant, _that.getVariant());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifer != null ? ((Object)((Object)this.identifer)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.otherParty != null ? this.otherParty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.variant != null ? this.variant.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MasterAgreementClause {identifer=" + (Object)((Object)this.identifer) + ", name=" + this.name + ", counterparty=" + this.counterparty + ", otherParty=" + this.otherParty + ", variant=" + this.variant + '}';
        }
    }

    public static interface MasterAgreementClauseBuilder
    extends MasterAgreementClause,
    RosettaModelObjectBuilder {
        public MasterAgreementClauseVariant.MasterAgreementClauseVariantBuilder getOrCreateVariant(int var1);

        public List<? extends MasterAgreementClauseVariant.MasterAgreementClauseVariantBuilder> getVariant();

        public MasterAgreementClauseBuilder setIdentifer(MasterAgreementClauseIdentifierEnum var1);

        public MasterAgreementClauseBuilder setName(String var1);

        public MasterAgreementClauseBuilder addCounterparty(CounterpartyRoleEnum var1);

        public MasterAgreementClauseBuilder addCounterparty(CounterpartyRoleEnum var1, int var2);

        public MasterAgreementClauseBuilder addCounterparty(List<? extends CounterpartyRoleEnum> var1);

        public MasterAgreementClauseBuilder setCounterparty(List<? extends CounterpartyRoleEnum> var1);

        public MasterAgreementClauseBuilder addOtherParty(PartyRoleEnum var1);

        public MasterAgreementClauseBuilder addOtherParty(PartyRoleEnum var1, int var2);

        public MasterAgreementClauseBuilder addOtherParty(List<? extends PartyRoleEnum> var1);

        public MasterAgreementClauseBuilder setOtherParty(List<? extends PartyRoleEnum> var1);

        public MasterAgreementClauseBuilder addVariant(MasterAgreementClauseVariant var1);

        public MasterAgreementClauseBuilder addVariant(MasterAgreementClauseVariant var1, int var2);

        public MasterAgreementClauseBuilder addVariant(List<? extends MasterAgreementClauseVariant> var1);

        public MasterAgreementClauseBuilder setVariant(List<? extends MasterAgreementClauseVariant> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("identifer"), MasterAgreementClauseIdentifierEnum.class, (Object)this.getIdentifer(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty"), CounterpartyRoleEnum.class, this.getCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherParty"), PartyRoleEnum.class, this.getOtherParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("variant"), processor, MasterAgreementClauseVariant.MasterAgreementClauseVariantBuilder.class, this.getVariant(), new AttributeMeta[0]);
        }

        public MasterAgreementClauseBuilder prune();
    }
}

