/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="ResourceTypeEnum")
public enum ResourceTypeEnum {
    CONFIRMATION("Confirmation"),
    SUPPLEMENTAL_MATERIAL_ECONOMIC_TERMS("SupplementalMaterialEconomicTerms"),
    TERM_SHEET("TermSheet");

    private static Map<String, ResourceTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private ResourceTypeEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private ResourceTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static ResourceTypeEnum fromDisplayName(String name) {
        ResourceTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, ResourceTypeEnum> map = new ConcurrentHashMap<String, ResourceTypeEnum>();
        for (ResourceTypeEnum instance : ResourceTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

