/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="TradeSecurityPartyRoleBuyerSeller")
@ImplementedBy(value=Default.class)
public interface TradeSecurityPartyRoleBuyerSeller
extends Validator<Trade> {
    public static final String NAME = "TradeSecurityPartyRoleBuyerSeller";
    public static final String DEFINITION = "if tradableProduct -> product -> security exists then partyRole -> role contains PartyRoleEnum -> Buyer and partyRole -> role contains PartyRoleEnum -> Seller";

    public ValidationResult<Trade> validate(RosettaPath var1, Trade var2);

    public static class NoOp
    implements TradeSecurityPartyRoleBuyerSeller {
        @Override
        public ValidationResult<Trade> validate(RosettaPath path, Trade trade) {
            return ValidationResult.success((String)TradeSecurityPartyRoleBuyerSeller.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeSecurityPartyRoleBuyerSeller.DEFINITION);
        }
    }

    public static class Default
    implements TradeSecurityPartyRoleBuyerSeller {
        @Override
        public ValidationResult<Trade> validate(RosettaPath path, Trade trade) {
            ComparisonResult result = this.executeDataRule(trade);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TradeSecurityPartyRoleBuyerSeller.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeSecurityPartyRoleBuyerSeller.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TradeSecurityPartyRoleBuyerSeller failed.";
            }
            return ValidationResult.failure((String)TradeSecurityPartyRoleBuyerSeller.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeSecurityPartyRoleBuyerSeller.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Trade trade) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getSecurity", product -> product.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.contains((Mapper)MapperS.of((Object)trade).mapC("getPartyRole", _trade -> _trade.getPartyRole()).map("getRole", partyRole -> partyRole.getRole()), (Mapper)MapperS.of((Object)((Object)PartyRoleEnum.BUYER))).and(ExpressionOperators.contains((Mapper)MapperS.of((Object)trade).mapC("getPartyRole", _trade -> _trade.getPartyRole()).map("getRole", partyRole -> partyRole.getRole()), (Mapper)MapperS.of((Object)((Object)PartyRoleEnum.SELLER))));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

