/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.math.BigDecimal;

@ImplementedBy(value=RateOfReturnDefault.class)
public abstract class RateOfReturn
implements RosettaFunction {
    public BigDecimal evaluate(PriceSchedule initialPrice, PriceSchedule finalPrice) {
        BigDecimal rateOfReturn = this.doEvaluate(initialPrice, finalPrice);
        return rateOfReturn;
    }

    protected abstract BigDecimal doEvaluate(PriceSchedule var1, PriceSchedule var2);

    protected abstract Mapper<BigDecimal> initialPriceValue(PriceSchedule var1, PriceSchedule var2);

    protected abstract Mapper<BigDecimal> finalPriceValue(PriceSchedule var1, PriceSchedule var2);

    public static class RateOfReturnDefault
    extends RateOfReturn {
        @Override
        protected BigDecimal doEvaluate(PriceSchedule initialPrice, PriceSchedule finalPrice) {
            BigDecimal rateOfReturn = null;
            return this.assignOutput(rateOfReturn, initialPrice, finalPrice);
        }

        protected BigDecimal assignOutput(BigDecimal rateOfReturn, PriceSchedule initialPrice, PriceSchedule finalPrice) {
            rateOfReturn = (BigDecimal)MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.finalPriceValue(initialPrice, finalPrice).get()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.initialPriceValue(initialPrice, finalPrice).get())))).and(ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)((BigDecimal)this.initialPriceValue(initialPrice, finalPrice).get())), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperMaths.divide((Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((BigDecimal)this.finalPriceValue(initialPrice, finalPrice).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.initialPriceValue(initialPrice, finalPrice).get()))), (Mapper)MapperS.of((Object)((BigDecimal)this.initialPriceValue(initialPrice, finalPrice).get())));
                }
                return null;
            }).get();
            return rateOfReturn;
        }

        @Override
        protected Mapper<BigDecimal> initialPriceValue(PriceSchedule initialPrice, PriceSchedule finalPrice) {
            return MapperS.of((Object)initialPrice).map("getValue", measureBase -> measureBase.getValue());
        }

        @Override
        protected Mapper<BigDecimal> finalPriceValue(PriceSchedule initialPrice, PriceSchedule finalPrice) {
            return MapperS.of((Object)finalPrice).map("getValue", measureBase -> measureBase.getValue());
        }
    }
}

