/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.event.common.Reset;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.event.common.functions.EquityPerformance;
import cdm.event.common.functions.ResolveCashSettlementDate;
import cdm.observable.asset.Price;
import cdm.product.asset.functions.ResolveEquityInitialPrice;
import cdm.product.template.PerformancePayout;
import cdm.product.template.TradeLot;
import cdm.product.template.metafields.ReferenceWithMetaPerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=EquityCashSettlementAmountDefault.class)
public abstract class EquityCashSettlementAmount
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;
    @Inject
    protected EquityPerformance equityPerformance0;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected ResolveCashSettlementDate resolveCashSettlementDate;
    @Inject
    protected ResolveEquityInitialPrice resolveEquityInitialPrice;

    public Transfer evaluate(TradeState tradeState, Date date) {
        Transfer equityCashSettlementAmount;
        Transfer.TransferBuilder equityCashSettlementAmountBuilder = this.doEvaluate(tradeState, date);
        if (equityCashSettlementAmountBuilder == null) {
            equityCashSettlementAmount = null;
        } else {
            equityCashSettlementAmount = equityCashSettlementAmountBuilder.build();
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)equityCashSettlementAmount);
        }
        return equityCashSettlementAmount;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(TradeState var1, Date var2);

    protected abstract Mapper<? extends PerformancePayout> equityPerformancePayout(TradeState var1, Date var2);

    protected abstract Mapper<BigDecimal> equityPerformance1(TradeState var1, Date var2);

    protected abstract Mapper<? extends Party> payer(TradeState var1, Date var2);

    protected abstract Mapper<? extends Party> receiver(TradeState var1, Date var2);

    public static class EquityCashSettlementAmountDefault
    extends EquityCashSettlementAmount {
        @Override
        protected Transfer.TransferBuilder doEvaluate(TradeState tradeState, Date date) {
            Transfer.TransferBuilder equityCashSettlementAmount = Transfer.builder();
            return this.assignOutput(equityCashSettlementAmount, tradeState, date);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder equityCashSettlementAmount, TradeState tradeState, Date date) {
            equityCashSettlementAmount.getOrCreateQuantity().setValue((BigDecimal)MapperS.of((Object)this.abs.evaluate((BigDecimal)MapperS.of((Object)((BigDecimal)this.equityPerformance1(tradeState, date).get())).get())).get());
            equityCashSettlementAmount.getOrCreateQuantity().getOrCreateUnit().setCurrencyValue((String)MapperS.of((Object)this.resolveEquityInitialPrice.evaluate(MapperS.of((Object)((TradeLot)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).getMulti())).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()).get());
            equityCashSettlementAmount.getOrCreatePayerReceiver().setPayerPartyReferenceValue((Party)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)((BigDecimal)this.equityPerformance1(tradeState, date).get())), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Party)this.payer(tradeState, date).get()));
                }
                return MapperS.of((Object)((Party)this.receiver(tradeState, date).get()));
            }).get());
            equityCashSettlementAmount.getOrCreatePayerReceiver().setReceiverPartyReferenceValue((Party)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)((BigDecimal)this.equityPerformance1(tradeState, date).get())), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Party)this.receiver(tradeState, date).get()));
                }
                return MapperS.of((Object)((Party)this.payer(tradeState, date).get()));
            }).get());
            equityCashSettlementAmount.getOrCreateSettlementDate().setAdjustedDateValue((Date)MapperS.of((Object)this.resolveCashSettlementDate.evaluate((TradeState)MapperS.of((Object)tradeState).get())).get());
            equityCashSettlementAmount.getOrCreateSettlementOrigin().setPerformancePayout(ReferenceWithMetaPerformancePayout.builder().setGlobalReference(Optional.ofNullable((PerformancePayout)MapperS.of((Object)((PerformancePayout)this.equityPerformancePayout(tradeState, date).get())).get()).map(r -> r.getMeta()).map(m -> m.getGlobalKey()).orElse(null)).setExternalReference(Optional.ofNullable((PerformancePayout)MapperS.of((Object)((PerformancePayout)this.equityPerformancePayout(tradeState, date).get())).get()).map(r -> r.getMeta()).map(m -> m.getExternalKey()).orElse(null)).build());
            return Optional.ofNullable(equityCashSettlementAmount).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends PerformancePayout> equityPerformancePayout(TradeState tradeState, Date date) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()));
        }

        @Override
        protected Mapper<BigDecimal> equityPerformance1(TradeState tradeState, Date date) {
            return MapperS.of((Object)this.equityPerformance0.evaluate((Trade)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).get(), (Price)MapperS.of((Object)((Reset)MapperS.of((Object)tradeState).mapC("getResetHistory", _tradeState -> _tradeState.getResetHistory()).get())).map("getResetValue", reset -> reset.getResetValue()).get(), (Date)MapperS.of((Object)date).get()));
        }

        @Override
        protected Mapper<? extends Party> payer(TradeState tradeState, Date date) {
            return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)MapperS.of((Object)((PerformancePayout)this.equityPerformancePayout(tradeState, date).get())).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
        }

        @Override
        protected Mapper<? extends Party> receiver(TradeState tradeState, Date date) {
            return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)MapperS.of((Object)((PerformancePayout)this.equityPerformancePayout(tradeState, date).get())).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
        }
    }
}

