/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.event.common.CollateralPortfolio;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.TermsChangeInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.functions.Create_SubstitutionInstruction;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.ContractualProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_SubstitutionPrimitiveInstructionDefault.class)
public abstract class Create_SubstitutionPrimitiveInstruction
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_SubstitutionInstruction create_SubstitutionInstruction;

    public PrimitiveInstruction evaluate(TradeState tradeState, AdjustableOrRelativeDate effectiveDate, CollateralPortfolio newCollateralPortfolio, List<? extends PriceQuantity> priceQuantity) {
        PrimitiveInstruction instruction;
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct())), "Only a security finance contractual product can substitute collateral.");
        PrimitiveInstruction.PrimitiveInstructionBuilder instructionBuilder = this.doEvaluate(tradeState, effectiveDate, newCollateralPortfolio, priceQuantity);
        if (instructionBuilder == null) {
            instruction = null;
        } else {
            instruction = instructionBuilder.build();
            this.objectValidator.validate(PrimitiveInstruction.class, (RosettaModelObject)instruction);
        }
        return instruction;
    }

    protected abstract PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState var1, AdjustableOrRelativeDate var2, CollateralPortfolio var3, List<? extends PriceQuantity> var4);

    public static class Create_SubstitutionPrimitiveInstructionDefault
    extends Create_SubstitutionPrimitiveInstruction {
        @Override
        protected PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState tradeState, AdjustableOrRelativeDate effectiveDate, CollateralPortfolio newCollateralPortfolio, List<? extends PriceQuantity> priceQuantity) {
            PrimitiveInstruction.PrimitiveInstructionBuilder instruction = PrimitiveInstruction.builder();
            return this.assignOutput(instruction, tradeState, effectiveDate, newCollateralPortfolio, priceQuantity);
        }

        protected PrimitiveInstruction.PrimitiveInstructionBuilder assignOutput(PrimitiveInstruction.PrimitiveInstructionBuilder instruction, TradeState tradeState, AdjustableOrRelativeDate effectiveDate, CollateralPortfolio newCollateralPortfolio, List<? extends PriceQuantity> priceQuantity) {
            instruction = (PrimitiveInstruction.PrimitiveInstructionBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)PrimitiveInstruction.builder().setQuantityChange((QuantityChangeInstruction)MapperS.of((Object)QuantityChangeInstruction.builder().setChange(MapperC.of(priceQuantity).getMulti()).setDirection((QuantityChangeDirectionEnum)((Object)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.REPLACE)).get())).setLotIdentifier(MapperC.ofNull().getMulti()).build()).get()).setTermsChange((TermsChangeInstruction)MapperS.of((Object)this.create_SubstitutionInstruction.evaluate((ContractualProduct)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).get(), (AdjustableOrRelativeDate)MapperS.of((Object)effectiveDate).get(), (CollateralPortfolio)MapperS.of((Object)newCollateralPortfolio).get())).get()).build()).get());
            return Optional.ofNullable(instruction).map(o -> o.prune()).orElse(null);
        }
    }
}

