/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.ProductBase;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.meta.LoanMeta;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.base.staticdata.party.LegalEntity;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Loan", builder=LoanBuilderImpl.class, version="5.0.0")
public interface Loan
extends ProductBase {
    public static final LoanMeta metaData = new LoanMeta();

    public List<? extends LegalEntity> getBorrower();

    public FieldWithMetaString getLien();

    public FieldWithMetaString getFacilityType();

    public Date getCreditAgreementDate();

    public FieldWithMetaString getTranche();

    @Override
    public Loan build();

    @Override
    public LoanBuilder toBuilder();

    public static LoanBuilder builder() {
        return new LoanBuilderImpl();
    }

    default public RosettaMetaData<? extends Loan> metaData() {
        return metaData;
    }

    default public Class<? extends Loan> getType() {
        return Loan.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        ProductBase.super.process(path, processor);
        processor.processBasic(path.newSubPath("creditAgreementDate"), Date.class, (Object)this.getCreditAgreementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("borrower"), processor, LegalEntity.class, this.getBorrower(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lien"), processor, FieldWithMetaString.class, this.getLien(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityType"), processor, FieldWithMetaString.class, this.getFacilityType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tranche"), processor, FieldWithMetaString.class, this.getTranche(), new AttributeMeta[0]);
    }

    public static class LoanBuilderImpl
    extends ProductBase.ProductBaseBuilderImpl
    implements LoanBuilder {
        protected List<LegalEntity.LegalEntityBuilder> borrower = new ArrayList<LegalEntity.LegalEntityBuilder>();
        protected FieldWithMetaString.FieldWithMetaStringBuilder lien;
        protected FieldWithMetaString.FieldWithMetaStringBuilder facilityType;
        protected Date creditAgreementDate;
        protected FieldWithMetaString.FieldWithMetaStringBuilder tranche;

        @Override
        @RosettaAttribute(value="borrower")
        public List<? extends LegalEntity.LegalEntityBuilder> getBorrower() {
            return this.borrower;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateBorrower(int _index) {
            if (this.borrower == null) {
                this.borrower = new ArrayList<LegalEntity.LegalEntityBuilder>();
            }
            return (LegalEntity.LegalEntityBuilder)this.getIndex(this.borrower, _index, () -> {
                LegalEntity.LegalEntityBuilder newBorrower = LegalEntity.builder();
                return newBorrower;
            });
        }

        @Override
        @RosettaAttribute(value="lien")
        public FieldWithMetaString.FieldWithMetaStringBuilder getLien() {
            return this.lien;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateLien() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.lien != null ? this.lien : (this.lien = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityType")
        public FieldWithMetaString.FieldWithMetaStringBuilder getFacilityType() {
            return this.facilityType;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateFacilityType() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.facilityType != null ? this.facilityType : (this.facilityType = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditAgreementDate")
        public Date getCreditAgreementDate() {
            return this.creditAgreementDate;
        }

        @Override
        @RosettaAttribute(value="tranche")
        public FieldWithMetaString.FieldWithMetaStringBuilder getTranche() {
            return this.tranche;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateTranche() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.tranche != null ? this.tranche : (this.tranche = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public LoanBuilder addBorrower(LegalEntity borrower) {
            if (borrower != null) {
                this.borrower.add(borrower.toBuilder());
            }
            return this;
        }

        @Override
        public LoanBuilder addBorrower(LegalEntity borrower, int _idx) {
            this.getIndex(this.borrower, _idx, () -> borrower.toBuilder());
            return this;
        }

        @Override
        public LoanBuilder addBorrower(List<? extends LegalEntity> borrowers) {
            if (borrowers != null) {
                for (LegalEntity legalEntity : borrowers) {
                    this.borrower.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="borrower")
        public LoanBuilder setBorrower(List<? extends LegalEntity> borrowers) {
            this.borrower = borrowers == null ? new ArrayList<LegalEntity.LegalEntityBuilder>() : (List)borrowers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="lien")
        public LoanBuilder setLien(FieldWithMetaString lien) {
            this.lien = lien == null ? null : lien.toBuilder();
            return this;
        }

        @Override
        public LoanBuilder setLienValue(String lien) {
            this.getOrCreateLien().setValue(lien);
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityType")
        public LoanBuilder setFacilityType(FieldWithMetaString facilityType) {
            this.facilityType = facilityType == null ? null : facilityType.toBuilder();
            return this;
        }

        @Override
        public LoanBuilder setFacilityTypeValue(String facilityType) {
            this.getOrCreateFacilityType().setValue(facilityType);
            return this;
        }

        @Override
        @RosettaAttribute(value="creditAgreementDate")
        public LoanBuilder setCreditAgreementDate(Date creditAgreementDate) {
            this.creditAgreementDate = creditAgreementDate == null ? null : creditAgreementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="tranche")
        public LoanBuilder setTranche(FieldWithMetaString tranche) {
            this.tranche = tranche == null ? null : tranche.toBuilder();
            return this;
        }

        @Override
        public LoanBuilder setTrancheValue(String tranche) {
            this.getOrCreateTranche().setValue(tranche);
            return this;
        }

        @Override
        public LoanBuilder addProductTaxonomy(ProductTaxonomy productTaxonomy) {
            if (productTaxonomy != null) {
                this.productTaxonomy.add(productTaxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public LoanBuilder addProductTaxonomy(ProductTaxonomy productTaxonomy, int _idx) {
            this.getIndex(this.productTaxonomy, _idx, () -> productTaxonomy.toBuilder());
            return this;
        }

        @Override
        public LoanBuilder addProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            if (productTaxonomys != null) {
                for (ProductTaxonomy productTaxonomy : productTaxonomys) {
                    this.productTaxonomy.add(productTaxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="productTaxonomy")
        public LoanBuilder setProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            this.productTaxonomy = productTaxonomys == null ? new ArrayList() : (List)productTaxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier productIdentifier) {
            if (productIdentifier != null) {
                this.productIdentifier.add(productIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public LoanBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier productIdentifier, int _idx) {
            this.getIndex(this.productIdentifier, _idx, () -> productIdentifier.toBuilder());
            return this;
        }

        @Override
        public LoanBuilder addProductIdentifierValue(ProductIdentifier productIdentifier) {
            this.getOrCreateProductIdentifier(-1).setValue(productIdentifier.toBuilder());
            return this;
        }

        @Override
        public LoanBuilder addProductIdentifierValue(ProductIdentifier productIdentifier, int _idx) {
            this.getOrCreateProductIdentifier(_idx).setValue(productIdentifier.toBuilder());
            return this;
        }

        @Override
        public LoanBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ReferenceWithMetaProductIdentifier referenceWithMetaProductIdentifier : productIdentifiers) {
                    this.productIdentifier.add(referenceWithMetaProductIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        public LoanBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            this.productIdentifier = productIdentifiers == null ? new ArrayList() : (List)productIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanBuilder addProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ProductIdentifier productIdentifier : productIdentifiers) {
                    this.addProductIdentifierValue(productIdentifier);
                }
            }
            return this;
        }

        @Override
        public LoanBuilder setProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            this.productIdentifier.clear();
            if (productIdentifiers != null) {
                productIdentifiers.forEach(this::addProductIdentifierValue);
            }
            return this;
        }

        @Override
        public Loan build() {
            return new LoanImpl(this);
        }

        @Override
        public LoanBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanBuilder prune() {
            super.prune();
            this.borrower = this.borrower.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.lien != null && !this.lien.prune().hasData()) {
                this.lien = null;
            }
            if (this.facilityType != null && !this.facilityType.prune().hasData()) {
                this.facilityType = null;
            }
            if (this.tranche != null && !this.tranche.prune().hasData()) {
                this.tranche = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBorrower() != null && this.getBorrower().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLien() != null) {
                return true;
            }
            if (this.getFacilityType() != null) {
                return true;
            }
            if (this.getCreditAgreementDate() != null) {
                return true;
            }
            return this.getTranche() != null;
        }

        @Override
        public LoanBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanBuilder o = (LoanBuilder)other;
            merger.mergeRosetta(this.getBorrower(), o.getBorrower(), this::getOrCreateBorrower);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLien(), (RosettaModelObjectBuilder)o.getLien(), this::setLien);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityType(), (RosettaModelObjectBuilder)o.getFacilityType(), this::setFacilityType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTranche(), (RosettaModelObjectBuilder)o.getTranche(), this::setTranche);
            merger.mergeBasic((Object)this.getCreditAgreementDate(), (Object)o.getCreditAgreementDate(), this::setCreditAgreementDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Loan _that = (Loan)this.getType().cast(o);
            if (!ListEquals.listEquals(this.borrower, _that.getBorrower())) {
                return false;
            }
            if (!Objects.equals(this.lien, _that.getLien())) {
                return false;
            }
            if (!Objects.equals(this.facilityType, _that.getFacilityType())) {
                return false;
            }
            if (!Objects.equals(this.creditAgreementDate, _that.getCreditAgreementDate())) {
                return false;
            }
            return Objects.equals(this.tranche, _that.getTranche());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.borrower != null ? this.borrower.hashCode() : 0);
            _result = 31 * _result + (this.lien != null ? this.lien.hashCode() : 0);
            _result = 31 * _result + (this.facilityType != null ? this.facilityType.hashCode() : 0);
            _result = 31 * _result + (this.creditAgreementDate != null ? this.creditAgreementDate.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanBuilder {borrower=" + this.borrower + ", lien=" + this.lien + ", facilityType=" + this.facilityType + ", creditAgreementDate=" + this.creditAgreementDate + ", tranche=" + this.tranche + '}' + " " + super.toString();
        }
    }

    public static class LoanImpl
    extends ProductBase.ProductBaseImpl
    implements Loan {
        private final List<? extends LegalEntity> borrower;
        private final FieldWithMetaString lien;
        private final FieldWithMetaString facilityType;
        private final Date creditAgreementDate;
        private final FieldWithMetaString tranche;

        protected LoanImpl(LoanBuilder builder) {
            super(builder);
            this.borrower = Optional.ofNullable(builder.getBorrower()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.lien = Optional.ofNullable(builder.getLien()).map(f -> f.build()).orElse(null);
            this.facilityType = Optional.ofNullable(builder.getFacilityType()).map(f -> f.build()).orElse(null);
            this.creditAgreementDate = builder.getCreditAgreementDate();
            this.tranche = Optional.ofNullable(builder.getTranche()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="borrower")
        public List<? extends LegalEntity> getBorrower() {
            return this.borrower;
        }

        @Override
        @RosettaAttribute(value="lien")
        public FieldWithMetaString getLien() {
            return this.lien;
        }

        @Override
        @RosettaAttribute(value="facilityType")
        public FieldWithMetaString getFacilityType() {
            return this.facilityType;
        }

        @Override
        @RosettaAttribute(value="creditAgreementDate")
        public Date getCreditAgreementDate() {
            return this.creditAgreementDate;
        }

        @Override
        @RosettaAttribute(value="tranche")
        public FieldWithMetaString getTranche() {
            return this.tranche;
        }

        @Override
        public Loan build() {
            return this;
        }

        @Override
        public LoanBuilder toBuilder() {
            LoanBuilder builder = Loan.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBorrower()).ifPresent(builder::setBorrower);
            Optional.ofNullable(this.getLien()).ifPresent(builder::setLien);
            Optional.ofNullable(this.getFacilityType()).ifPresent(builder::setFacilityType);
            Optional.ofNullable(this.getCreditAgreementDate()).ifPresent(builder::setCreditAgreementDate);
            Optional.ofNullable(this.getTranche()).ifPresent(builder::setTranche);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Loan _that = (Loan)this.getType().cast(o);
            if (!ListEquals.listEquals(this.borrower, _that.getBorrower())) {
                return false;
            }
            if (!Objects.equals(this.lien, _that.getLien())) {
                return false;
            }
            if (!Objects.equals(this.facilityType, _that.getFacilityType())) {
                return false;
            }
            if (!Objects.equals(this.creditAgreementDate, _that.getCreditAgreementDate())) {
                return false;
            }
            return Objects.equals(this.tranche, _that.getTranche());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.borrower != null ? this.borrower.hashCode() : 0);
            _result = 31 * _result + (this.lien != null ? this.lien.hashCode() : 0);
            _result = 31 * _result + (this.facilityType != null ? this.facilityType.hashCode() : 0);
            _result = 31 * _result + (this.creditAgreementDate != null ? this.creditAgreementDate.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Loan {borrower=" + this.borrower + ", lien=" + this.lien + ", facilityType=" + this.facilityType + ", creditAgreementDate=" + this.creditAgreementDate + ", tranche=" + this.tranche + '}' + " " + super.toString();
        }
    }

    public static interface LoanBuilder
    extends Loan,
    ProductBase.ProductBaseBuilder,
    RosettaModelObjectBuilder {
        public LegalEntity.LegalEntityBuilder getOrCreateBorrower(int var1);

        public List<? extends LegalEntity.LegalEntityBuilder> getBorrower();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateLien();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getLien();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateFacilityType();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getFacilityType();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateTranche();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getTranche();

        public LoanBuilder addBorrower(LegalEntity var1);

        public LoanBuilder addBorrower(LegalEntity var1, int var2);

        public LoanBuilder addBorrower(List<? extends LegalEntity> var1);

        public LoanBuilder setBorrower(List<? extends LegalEntity> var1);

        public LoanBuilder setLien(FieldWithMetaString var1);

        public LoanBuilder setLienValue(String var1);

        public LoanBuilder setFacilityType(FieldWithMetaString var1);

        public LoanBuilder setFacilityTypeValue(String var1);

        public LoanBuilder setCreditAgreementDate(Date var1);

        public LoanBuilder setTranche(FieldWithMetaString var1);

        public LoanBuilder setTrancheValue(String var1);

        @Override
        public LoanBuilder addProductTaxonomy(ProductTaxonomy var1);

        @Override
        public LoanBuilder addProductTaxonomy(ProductTaxonomy var1, int var2);

        @Override
        public LoanBuilder addProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public LoanBuilder setProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public LoanBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1);

        @Override
        public LoanBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1, int var2);

        @Override
        public LoanBuilder addProductIdentifierValue(ProductIdentifier var1);

        @Override
        public LoanBuilder addProductIdentifierValue(ProductIdentifier var1, int var2);

        @Override
        public LoanBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public LoanBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public LoanBuilder addProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        public LoanBuilder setProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            ProductBase.ProductBaseBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("creditAgreementDate"), Date.class, (Object)this.getCreditAgreementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("borrower"), processor, LegalEntity.LegalEntityBuilder.class, this.getBorrower(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lien"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getLien(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityType"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getFacilityType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tranche"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getTranche(), new AttributeMeta[0]);
        }

        @Override
        public LoanBuilder prune();
    }
}

