/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.functions.ArithmeticOperation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=VectorScalarOperationDefault.class)
public abstract class VectorScalarOperation
implements RosettaFunction {
    @Inject
    protected ArithmeticOperation arithmeticOperation;

    public List<BigDecimal> evaluate(ArithmeticOperationEnum arithmeticOp, List<BigDecimal> left, BigDecimal right) {
        List<BigDecimal> result = this.doEvaluate(arithmeticOp, left, right);
        return result;
    }

    protected abstract List<BigDecimal> doEvaluate(ArithmeticOperationEnum var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract Mapper<BigDecimal> rightOrDefault(ArithmeticOperationEnum var1, List<BigDecimal> var2, BigDecimal var3);

    public static class VectorScalarOperationDefault
    extends VectorScalarOperation {
        @Override
        protected List<BigDecimal> doEvaluate(ArithmeticOperationEnum arithmeticOp, List<BigDecimal> left, BigDecimal right) {
            ArrayList<BigDecimal> result = new ArrayList<BigDecimal>();
            return this.assignOutput(result, arithmeticOp, left, right);
        }

        protected List<BigDecimal> assignOutput(List<BigDecimal> result, ArithmeticOperationEnum arithmeticOp, List<BigDecimal> left, BigDecimal right) {
            List addVar = MapperC.of(left).mapItem(item -> MapperS.of((Object)this.arithmeticOperation.evaluate((BigDecimal)item.get(), (ArithmeticOperationEnum)((Object)((Object)MapperS.of((Object)((Object)arithmeticOp)).get())), (BigDecimal)MapperS.of((Object)((BigDecimal)this.rightOrDefault(arithmeticOp, left, right).get())).get()))).getMulti();
            result.addAll(addVar);
            return result;
        }

        @Override
        protected Mapper<BigDecimal> rightOrDefault(ArithmeticOperationEnum arithmeticOp, List<BigDecimal> left, BigDecimal right) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)right)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)right);
                }
                return MapperS.of((Object)new BigDecimal("0.0"));
            });
        }
    }
}

