/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.functions.IsHoliday;
import cdm.base.datetime.functions.IsWeekend;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=IsBusinessDayDefault.class)
public abstract class IsBusinessDay
implements RosettaFunction {
    @Inject
    protected IsHoliday isHoliday;
    @Inject
    protected IsWeekend isWeekend;

    public Boolean evaluate(Date date, List<BusinessCenterEnum> businessCenters) {
        Boolean isGoodBusinessDay = this.doEvaluate(date, businessCenters);
        return isGoodBusinessDay;
    }

    protected abstract Boolean doEvaluate(Date var1, List<BusinessCenterEnum> var2);

    protected abstract Mapper<Boolean> weekend(Date var1, List<BusinessCenterEnum> var2);

    protected abstract Mapper<Boolean> holiday(Date var1, List<BusinessCenterEnum> var2);

    public static class IsBusinessDayDefault
    extends IsBusinessDay {
        @Override
        protected Boolean doEvaluate(Date date, List<BusinessCenterEnum> businessCenters) {
            Boolean isGoodBusinessDay = null;
            return this.assignOutput(isGoodBusinessDay, date, businessCenters);
        }

        protected Boolean assignOutput(Boolean isGoodBusinessDay, Date date, List<BusinessCenterEnum> businessCenters) {
            isGoodBusinessDay = (Boolean)MapperUtils.runSingle(() -> {
                if (((Boolean)MapperS.of((Object)((Boolean)this.weekend(date, businessCenters).get())).getOrDefault((Object)false)).booleanValue()) {
                    return MapperS.of((Object)false);
                }
                if (((Boolean)MapperS.of((Object)((Boolean)this.holiday(date, businessCenters).get())).getOrDefault((Object)false)).booleanValue()) {
                    return MapperS.of((Object)false);
                }
                return MapperS.of((Object)true);
            }).get();
            return isGoodBusinessDay;
        }

        @Override
        protected Mapper<Boolean> weekend(Date date, List<BusinessCenterEnum> businessCenters) {
            return MapperS.of((Object)this.isWeekend.evaluate((Date)MapperS.of((Object)date).get(), MapperC.of(businessCenters).getMulti()));
        }

        @Override
        protected Mapper<Boolean> holiday(Date date, List<BusinessCenterEnum> businessCenters) {
            return MapperS.of((Object)this.isHoliday.evaluate((Date)MapperS.of((Object)date).get(), MapperC.of(businessCenters).getMulti()));
        }
    }
}

