/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.BusinessDayConventionEnum;
import cdm.base.datetime.DateRange;
import cdm.base.datetime.DayTypeEnum;
import cdm.base.datetime.PeriodEnum;
import cdm.base.datetime.RelativeDateOffset;
import cdm.base.datetime.meta.RelativeDatesMeta;
import cdm.base.datetime.metafields.ReferenceWithMetaBusinessCenters;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.model.metafields.ReferenceWithMetaDate;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RelativeDates", builder=RelativeDatesBuilderImpl.class, version="5.0.0")
public interface RelativeDates
extends RelativeDateOffset {
    public static final RelativeDatesMeta metaData = new RelativeDatesMeta();

    public Integer getPeriodSkip();

    public DateRange getScheduleBounds();

    @Override
    public RelativeDates build();

    @Override
    public RelativeDatesBuilder toBuilder();

    public static RelativeDatesBuilder builder() {
        return new RelativeDatesBuilderImpl();
    }

    default public RosettaMetaData<? extends RelativeDates> metaData() {
        return metaData;
    }

    default public Class<? extends RelativeDates> getType() {
        return RelativeDates.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        RelativeDateOffset.super.process(path, processor);
        processor.processBasic(path.newSubPath("periodSkip"), Integer.class, (Object)this.getPeriodSkip(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("scheduleBounds"), processor, DateRange.class, this.getScheduleBounds(), new AttributeMeta[0]);
    }

    public static class RelativeDatesBuilderImpl
    extends RelativeDateOffset.RelativeDateOffsetBuilderImpl
    implements RelativeDatesBuilder {
        protected Integer periodSkip;
        protected DateRange.DateRangeBuilder scheduleBounds;

        @Override
        @RosettaAttribute(value="periodSkip")
        public Integer getPeriodSkip() {
            return this.periodSkip;
        }

        @Override
        @RosettaAttribute(value="scheduleBounds")
        public DateRange.DateRangeBuilder getScheduleBounds() {
            return this.scheduleBounds;
        }

        @Override
        public DateRange.DateRangeBuilder getOrCreateScheduleBounds() {
            DateRange.DateRangeBuilder result = this.scheduleBounds != null ? this.scheduleBounds : (this.scheduleBounds = DateRange.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="periodSkip")
        public RelativeDatesBuilder setPeriodSkip(Integer periodSkip) {
            this.periodSkip = periodSkip == null ? null : periodSkip;
            return this;
        }

        @Override
        @RosettaAttribute(value="scheduleBounds")
        public RelativeDatesBuilder setScheduleBounds(DateRange scheduleBounds) {
            this.scheduleBounds = scheduleBounds == null ? null : scheduleBounds.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="businessDayConvention")
        public RelativeDatesBuilder setBusinessDayConvention(BusinessDayConventionEnum businessDayConvention) {
            this.businessDayConvention = businessDayConvention == null ? null : businessDayConvention;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCenters")
        public RelativeDatesBuilder setBusinessCenters(BusinessCenters businessCenters) {
            this.businessCenters = businessCenters == null ? null : businessCenters.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCentersReference")
        public RelativeDatesBuilder setBusinessCentersReference(ReferenceWithMetaBusinessCenters businessCentersReference) {
            this.businessCentersReference = businessCentersReference == null ? null : businessCentersReference.toBuilder();
            return this;
        }

        @Override
        public RelativeDatesBuilder setBusinessCentersReferenceValue(BusinessCenters businessCentersReference) {
            this.getOrCreateBusinessCentersReference().setValue(businessCentersReference);
            return this;
        }

        @Override
        @RosettaAttribute(value="dateRelativeTo")
        public RelativeDatesBuilder setDateRelativeTo(ReferenceWithMetaDate dateRelativeTo) {
            this.dateRelativeTo = dateRelativeTo == null ? null : dateRelativeTo.toBuilder();
            return this;
        }

        @Override
        public RelativeDatesBuilder setDateRelativeToValue(Date dateRelativeTo) {
            this.getOrCreateDateRelativeTo().setValue(dateRelativeTo);
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedDate")
        public RelativeDatesBuilder setAdjustedDate(Date adjustedDate) {
            this.adjustedDate = adjustedDate == null ? null : adjustedDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="dayType")
        public RelativeDatesBuilder setDayType(DayTypeEnum dayType) {
            this.dayType = dayType == null ? null : dayType;
            return this;
        }

        @Override
        @RosettaAttribute(value="periodMultiplier")
        public RelativeDatesBuilder setPeriodMultiplier(Integer periodMultiplier) {
            this.periodMultiplier = periodMultiplier == null ? null : periodMultiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="period")
        public RelativeDatesBuilder setPeriod(PeriodEnum period) {
            this.period = period == null ? null : period;
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        public RelativeDatesBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public RelativeDates build() {
            return new RelativeDatesImpl(this);
        }

        @Override
        public RelativeDatesBuilder toBuilder() {
            return this;
        }

        @Override
        public RelativeDatesBuilder prune() {
            super.prune();
            if (this.scheduleBounds != null && !this.scheduleBounds.prune().hasData()) {
                this.scheduleBounds = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPeriodSkip() != null) {
                return true;
            }
            return this.getScheduleBounds() != null && this.getScheduleBounds().hasData();
        }

        @Override
        public RelativeDatesBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RelativeDatesBuilder o = (RelativeDatesBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getScheduleBounds(), (RosettaModelObjectBuilder)o.getScheduleBounds(), this::setScheduleBounds);
            merger.mergeBasic((Object)this.getPeriodSkip(), (Object)o.getPeriodSkip(), this::setPeriodSkip, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RelativeDates _that = (RelativeDates)this.getType().cast(o);
            if (!Objects.equals(this.periodSkip, _that.getPeriodSkip())) {
                return false;
            }
            return Objects.equals(this.scheduleBounds, _that.getScheduleBounds());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodSkip != null ? this.periodSkip.hashCode() : 0);
            _result = 31 * _result + (this.scheduleBounds != null ? this.scheduleBounds.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RelativeDatesBuilder {periodSkip=" + this.periodSkip + ", scheduleBounds=" + this.scheduleBounds + '}' + " " + super.toString();
        }
    }

    public static class RelativeDatesImpl
    extends RelativeDateOffset.RelativeDateOffsetImpl
    implements RelativeDates {
        private final Integer periodSkip;
        private final DateRange scheduleBounds;

        protected RelativeDatesImpl(RelativeDatesBuilder builder) {
            super(builder);
            this.periodSkip = builder.getPeriodSkip();
            this.scheduleBounds = Optional.ofNullable(builder.getScheduleBounds()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periodSkip")
        public Integer getPeriodSkip() {
            return this.periodSkip;
        }

        @Override
        @RosettaAttribute(value="scheduleBounds")
        public DateRange getScheduleBounds() {
            return this.scheduleBounds;
        }

        @Override
        public RelativeDates build() {
            return this;
        }

        @Override
        public RelativeDatesBuilder toBuilder() {
            RelativeDatesBuilder builder = RelativeDates.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RelativeDatesBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPeriodSkip()).ifPresent(builder::setPeriodSkip);
            Optional.ofNullable(this.getScheduleBounds()).ifPresent(builder::setScheduleBounds);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RelativeDates _that = (RelativeDates)this.getType().cast(o);
            if (!Objects.equals(this.periodSkip, _that.getPeriodSkip())) {
                return false;
            }
            return Objects.equals(this.scheduleBounds, _that.getScheduleBounds());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodSkip != null ? this.periodSkip.hashCode() : 0);
            _result = 31 * _result + (this.scheduleBounds != null ? this.scheduleBounds.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RelativeDates {periodSkip=" + this.periodSkip + ", scheduleBounds=" + this.scheduleBounds + '}' + " " + super.toString();
        }
    }

    public static interface RelativeDatesBuilder
    extends RelativeDates,
    RelativeDateOffset.RelativeDateOffsetBuilder,
    RosettaModelObjectBuilder {
        public DateRange.DateRangeBuilder getOrCreateScheduleBounds();

        @Override
        public DateRange.DateRangeBuilder getScheduleBounds();

        public RelativeDatesBuilder setPeriodSkip(Integer var1);

        public RelativeDatesBuilder setScheduleBounds(DateRange var1);

        @Override
        public RelativeDatesBuilder setBusinessDayConvention(BusinessDayConventionEnum var1);

        @Override
        public RelativeDatesBuilder setBusinessCenters(BusinessCenters var1);

        @Override
        public RelativeDatesBuilder setBusinessCentersReference(ReferenceWithMetaBusinessCenters var1);

        @Override
        public RelativeDatesBuilder setBusinessCentersReferenceValue(BusinessCenters var1);

        @Override
        public RelativeDatesBuilder setDateRelativeTo(ReferenceWithMetaDate var1);

        @Override
        public RelativeDatesBuilder setDateRelativeToValue(Date var1);

        @Override
        public RelativeDatesBuilder setAdjustedDate(Date var1);

        @Override
        public RelativeDatesBuilder setDayType(DayTypeEnum var1);

        @Override
        public RelativeDatesBuilder setPeriodMultiplier(Integer var1);

        @Override
        public RelativeDatesBuilder setPeriod(PeriodEnum var1);

        @Override
        public RelativeDatesBuilder setMeta(MetaFields var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            RelativeDateOffset.RelativeDateOffsetBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("periodSkip"), Integer.class, (Object)this.getPeriodSkip(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("scheduleBounds"), processor, DateRange.DateRangeBuilder.class, this.getScheduleBounds(), new AttributeMeta[0]);
        }

        @Override
        public RelativeDatesBuilder prune();
    }
}

