/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.CommodityBusinessCalendarEnum;
import cdm.base.datetime.meta.BusinessCentersMeta;
import cdm.base.datetime.metafields.FieldWithMetaBusinessCenterEnum;
import cdm.base.datetime.metafields.FieldWithMetaCommodityBusinessCalendarEnum;
import cdm.base.datetime.metafields.ReferenceWithMetaBusinessCenters;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="BusinessCenters", builder=BusinessCentersBuilderImpl.class, version="5.0.0")
public interface BusinessCenters
extends RosettaModelObject,
GlobalKey {
    public static final BusinessCentersMeta metaData = new BusinessCentersMeta();

    public List<? extends FieldWithMetaBusinessCenterEnum> getBusinessCenter();

    public List<? extends FieldWithMetaCommodityBusinessCalendarEnum> getCommodityBusinessCalendar();

    public ReferenceWithMetaBusinessCenters getBusinessCentersReference();

    public MetaFields getMeta();

    public BusinessCenters build();

    public BusinessCentersBuilder toBuilder();

    public static BusinessCentersBuilder builder() {
        return new BusinessCentersBuilderImpl();
    }

    default public RosettaMetaData<? extends BusinessCenters> metaData() {
        return metaData;
    }

    default public Class<? extends BusinessCenters> getType() {
        return BusinessCenters.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("businessCenter"), processor, FieldWithMetaBusinessCenterEnum.class, this.getBusinessCenter(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityBusinessCalendar"), processor, FieldWithMetaCommodityBusinessCalendarEnum.class, this.getCommodityBusinessCalendar(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessCentersReference"), processor, ReferenceWithMetaBusinessCenters.class, this.getBusinessCentersReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class BusinessCentersBuilderImpl
    implements BusinessCentersBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected List<FieldWithMetaBusinessCenterEnum.FieldWithMetaBusinessCenterEnumBuilder> businessCenter = new ArrayList<FieldWithMetaBusinessCenterEnum.FieldWithMetaBusinessCenterEnumBuilder>();
        protected List<FieldWithMetaCommodityBusinessCalendarEnum.FieldWithMetaCommodityBusinessCalendarEnumBuilder> commodityBusinessCalendar = new ArrayList<FieldWithMetaCommodityBusinessCalendarEnum.FieldWithMetaCommodityBusinessCalendarEnumBuilder>();
        protected ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder businessCentersReference;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="businessCenter")
        public List<? extends FieldWithMetaBusinessCenterEnum.FieldWithMetaBusinessCenterEnumBuilder> getBusinessCenter() {
            return this.businessCenter;
        }

        @Override
        public FieldWithMetaBusinessCenterEnum.FieldWithMetaBusinessCenterEnumBuilder getOrCreateBusinessCenter(int _index) {
            if (this.businessCenter == null) {
                this.businessCenter = new ArrayList<FieldWithMetaBusinessCenterEnum.FieldWithMetaBusinessCenterEnumBuilder>();
            }
            return (FieldWithMetaBusinessCenterEnum.FieldWithMetaBusinessCenterEnumBuilder)this.getIndex(this.businessCenter, _index, () -> {
                FieldWithMetaBusinessCenterEnum.FieldWithMetaBusinessCenterEnumBuilder newBusinessCenter = FieldWithMetaBusinessCenterEnum.builder();
                return newBusinessCenter;
            });
        }

        @Override
        @RosettaAttribute(value="commodityBusinessCalendar")
        public List<? extends FieldWithMetaCommodityBusinessCalendarEnum.FieldWithMetaCommodityBusinessCalendarEnumBuilder> getCommodityBusinessCalendar() {
            return this.commodityBusinessCalendar;
        }

        @Override
        public FieldWithMetaCommodityBusinessCalendarEnum.FieldWithMetaCommodityBusinessCalendarEnumBuilder getOrCreateCommodityBusinessCalendar(int _index) {
            if (this.commodityBusinessCalendar == null) {
                this.commodityBusinessCalendar = new ArrayList<FieldWithMetaCommodityBusinessCalendarEnum.FieldWithMetaCommodityBusinessCalendarEnumBuilder>();
            }
            return (FieldWithMetaCommodityBusinessCalendarEnum.FieldWithMetaCommodityBusinessCalendarEnumBuilder)this.getIndex(this.commodityBusinessCalendar, _index, () -> {
                FieldWithMetaCommodityBusinessCalendarEnum.FieldWithMetaCommodityBusinessCalendarEnumBuilder newCommodityBusinessCalendar = FieldWithMetaCommodityBusinessCalendarEnum.builder();
                return newCommodityBusinessCalendar;
            });
        }

        @Override
        @RosettaAttribute(value="businessCentersReference")
        public ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder getBusinessCentersReference() {
            return this.businessCentersReference;
        }

        @Override
        public ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder getOrCreateBusinessCentersReference() {
            ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder result = this.businessCentersReference != null ? this.businessCentersReference : (this.businessCentersReference = ReferenceWithMetaBusinessCenters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public BusinessCentersBuilder addBusinessCenter(FieldWithMetaBusinessCenterEnum businessCenter) {
            if (businessCenter != null) {
                this.businessCenter.add(businessCenter.toBuilder());
            }
            return this;
        }

        @Override
        public BusinessCentersBuilder addBusinessCenter(FieldWithMetaBusinessCenterEnum businessCenter, int _idx) {
            this.getIndex(this.businessCenter, _idx, () -> businessCenter.toBuilder());
            return this;
        }

        @Override
        public BusinessCentersBuilder addBusinessCenterValue(BusinessCenterEnum businessCenter) {
            this.getOrCreateBusinessCenter(-1).setValue(businessCenter);
            return this;
        }

        @Override
        public BusinessCentersBuilder addBusinessCenterValue(BusinessCenterEnum businessCenter, int _idx) {
            this.getOrCreateBusinessCenter(_idx).setValue(businessCenter);
            return this;
        }

        @Override
        public BusinessCentersBuilder addBusinessCenter(List<? extends FieldWithMetaBusinessCenterEnum> businessCenters) {
            if (businessCenters != null) {
                for (FieldWithMetaBusinessCenterEnum fieldWithMetaBusinessCenterEnum : businessCenters) {
                    this.businessCenter.add(fieldWithMetaBusinessCenterEnum.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCenter")
        public BusinessCentersBuilder setBusinessCenter(List<? extends FieldWithMetaBusinessCenterEnum> businessCenters) {
            this.businessCenter = businessCenters == null ? new ArrayList<FieldWithMetaBusinessCenterEnum.FieldWithMetaBusinessCenterEnumBuilder>() : (List)businessCenters.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BusinessCentersBuilder addBusinessCenterValue(List<? extends BusinessCenterEnum> businessCenters) {
            if (businessCenters != null) {
                for (BusinessCenterEnum businessCenterEnum : businessCenters) {
                    this.addBusinessCenterValue(businessCenterEnum);
                }
            }
            return this;
        }

        @Override
        public BusinessCentersBuilder setBusinessCenterValue(List<? extends BusinessCenterEnum> businessCenters) {
            this.businessCenter.clear();
            if (businessCenters != null) {
                businessCenters.forEach(this::addBusinessCenterValue);
            }
            return this;
        }

        @Override
        public BusinessCentersBuilder addCommodityBusinessCalendar(FieldWithMetaCommodityBusinessCalendarEnum commodityBusinessCalendar) {
            if (commodityBusinessCalendar != null) {
                this.commodityBusinessCalendar.add(commodityBusinessCalendar.toBuilder());
            }
            return this;
        }

        @Override
        public BusinessCentersBuilder addCommodityBusinessCalendar(FieldWithMetaCommodityBusinessCalendarEnum commodityBusinessCalendar, int _idx) {
            this.getIndex(this.commodityBusinessCalendar, _idx, () -> commodityBusinessCalendar.toBuilder());
            return this;
        }

        @Override
        public BusinessCentersBuilder addCommodityBusinessCalendarValue(CommodityBusinessCalendarEnum commodityBusinessCalendar) {
            this.getOrCreateCommodityBusinessCalendar(-1).setValue(commodityBusinessCalendar);
            return this;
        }

        @Override
        public BusinessCentersBuilder addCommodityBusinessCalendarValue(CommodityBusinessCalendarEnum commodityBusinessCalendar, int _idx) {
            this.getOrCreateCommodityBusinessCalendar(_idx).setValue(commodityBusinessCalendar);
            return this;
        }

        @Override
        public BusinessCentersBuilder addCommodityBusinessCalendar(List<? extends FieldWithMetaCommodityBusinessCalendarEnum> commodityBusinessCalendars) {
            if (commodityBusinessCalendars != null) {
                for (FieldWithMetaCommodityBusinessCalendarEnum fieldWithMetaCommodityBusinessCalendarEnum : commodityBusinessCalendars) {
                    this.commodityBusinessCalendar.add(fieldWithMetaCommodityBusinessCalendarEnum.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityBusinessCalendar")
        public BusinessCentersBuilder setCommodityBusinessCalendar(List<? extends FieldWithMetaCommodityBusinessCalendarEnum> commodityBusinessCalendars) {
            this.commodityBusinessCalendar = commodityBusinessCalendars == null ? new ArrayList<FieldWithMetaCommodityBusinessCalendarEnum.FieldWithMetaCommodityBusinessCalendarEnumBuilder>() : (List)commodityBusinessCalendars.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BusinessCentersBuilder addCommodityBusinessCalendarValue(List<? extends CommodityBusinessCalendarEnum> commodityBusinessCalendars) {
            if (commodityBusinessCalendars != null) {
                for (CommodityBusinessCalendarEnum commodityBusinessCalendarEnum : commodityBusinessCalendars) {
                    this.addCommodityBusinessCalendarValue(commodityBusinessCalendarEnum);
                }
            }
            return this;
        }

        @Override
        public BusinessCentersBuilder setCommodityBusinessCalendarValue(List<? extends CommodityBusinessCalendarEnum> commodityBusinessCalendars) {
            this.commodityBusinessCalendar.clear();
            if (commodityBusinessCalendars != null) {
                commodityBusinessCalendars.forEach(this::addCommodityBusinessCalendarValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCentersReference")
        public BusinessCentersBuilder setBusinessCentersReference(ReferenceWithMetaBusinessCenters businessCentersReference) {
            this.businessCentersReference = businessCentersReference == null ? null : businessCentersReference.toBuilder();
            return this;
        }

        @Override
        public BusinessCentersBuilder setBusinessCentersReferenceValue(BusinessCenters businessCentersReference) {
            this.getOrCreateBusinessCentersReference().setValue(businessCentersReference);
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        public BusinessCentersBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public BusinessCenters build() {
            return new BusinessCentersImpl(this);
        }

        @Override
        public BusinessCentersBuilder toBuilder() {
            return this;
        }

        @Override
        public BusinessCentersBuilder prune() {
            this.businessCenter = this.businessCenter.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.commodityBusinessCalendar = this.commodityBusinessCalendar.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.businessCentersReference != null && !this.businessCentersReference.prune().hasData()) {
                this.businessCentersReference = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBusinessCenter() != null && !this.getBusinessCenter().isEmpty()) {
                return true;
            }
            if (this.getCommodityBusinessCalendar() != null && !this.getCommodityBusinessCalendar().isEmpty()) {
                return true;
            }
            return this.getBusinessCentersReference() != null && this.getBusinessCentersReference().hasData();
        }

        public BusinessCentersBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BusinessCentersBuilder o = (BusinessCentersBuilder)other;
            merger.mergeRosetta(this.getBusinessCenter(), o.getBusinessCenter(), this::getOrCreateBusinessCenter);
            merger.mergeRosetta(this.getCommodityBusinessCalendar(), o.getCommodityBusinessCalendar(), this::getOrCreateCommodityBusinessCalendar);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessCentersReference(), (RosettaModelObjectBuilder)o.getBusinessCentersReference(), this::setBusinessCentersReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BusinessCenters _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.businessCenter, _that.getBusinessCenter())) {
                return false;
            }
            if (!ListEquals.listEquals(this.commodityBusinessCalendar, _that.getCommodityBusinessCalendar())) {
                return false;
            }
            if (!Objects.equals(this.businessCentersReference, _that.getBusinessCentersReference())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.businessCenter != null ? this.businessCenter.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.commodityBusinessCalendar != null ? this.commodityBusinessCalendar.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.businessCentersReference != null ? this.businessCentersReference.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BusinessCentersBuilder {businessCenter=" + this.businessCenter + ", commodityBusinessCalendar=" + this.commodityBusinessCalendar + ", businessCentersReference=" + this.businessCentersReference + ", meta=" + this.meta + '}';
        }
    }

    public static class BusinessCentersImpl
    implements BusinessCenters {
        private final List<? extends FieldWithMetaBusinessCenterEnum> businessCenter;
        private final List<? extends FieldWithMetaCommodityBusinessCalendarEnum> commodityBusinessCalendar;
        private final ReferenceWithMetaBusinessCenters businessCentersReference;
        private final MetaFields meta;

        protected BusinessCentersImpl(BusinessCentersBuilder builder) {
            this.businessCenter = Optional.ofNullable(builder.getBusinessCenter()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.commodityBusinessCalendar = Optional.ofNullable(builder.getCommodityBusinessCalendar()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.businessCentersReference = Optional.ofNullable(builder.getBusinessCentersReference()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="businessCenter")
        public List<? extends FieldWithMetaBusinessCenterEnum> getBusinessCenter() {
            return this.businessCenter;
        }

        @Override
        @RosettaAttribute(value="commodityBusinessCalendar")
        public List<? extends FieldWithMetaCommodityBusinessCalendarEnum> getCommodityBusinessCalendar() {
            return this.commodityBusinessCalendar;
        }

        @Override
        @RosettaAttribute(value="businessCentersReference")
        public ReferenceWithMetaBusinessCenters getBusinessCentersReference() {
            return this.businessCentersReference;
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public BusinessCenters build() {
            return this;
        }

        @Override
        public BusinessCentersBuilder toBuilder() {
            BusinessCentersBuilder builder = BusinessCenters.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BusinessCentersBuilder builder) {
            Optional.ofNullable(this.getBusinessCenter()).ifPresent(builder::setBusinessCenter);
            Optional.ofNullable(this.getCommodityBusinessCalendar()).ifPresent(builder::setCommodityBusinessCalendar);
            Optional.ofNullable(this.getBusinessCentersReference()).ifPresent(builder::setBusinessCentersReference);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BusinessCenters _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.businessCenter, _that.getBusinessCenter())) {
                return false;
            }
            if (!ListEquals.listEquals(this.commodityBusinessCalendar, _that.getCommodityBusinessCalendar())) {
                return false;
            }
            if (!Objects.equals(this.businessCentersReference, _that.getBusinessCentersReference())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.businessCenter != null ? this.businessCenter.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.commodityBusinessCalendar != null ? this.commodityBusinessCalendar.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.businessCentersReference != null ? this.businessCentersReference.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BusinessCenters {businessCenter=" + this.businessCenter + ", commodityBusinessCalendar=" + this.commodityBusinessCalendar + ", businessCentersReference=" + this.businessCentersReference + ", meta=" + this.meta + '}';
        }
    }

    public static interface BusinessCentersBuilder
    extends BusinessCenters,
    RosettaModelObjectBuilder {
        public FieldWithMetaBusinessCenterEnum.FieldWithMetaBusinessCenterEnumBuilder getOrCreateBusinessCenter(int var1);

        public List<? extends FieldWithMetaBusinessCenterEnum.FieldWithMetaBusinessCenterEnumBuilder> getBusinessCenter();

        public FieldWithMetaCommodityBusinessCalendarEnum.FieldWithMetaCommodityBusinessCalendarEnumBuilder getOrCreateCommodityBusinessCalendar(int var1);

        public List<? extends FieldWithMetaCommodityBusinessCalendarEnum.FieldWithMetaCommodityBusinessCalendarEnumBuilder> getCommodityBusinessCalendar();

        public ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder getOrCreateBusinessCentersReference();

        @Override
        public ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder getBusinessCentersReference();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public BusinessCentersBuilder addBusinessCenter(FieldWithMetaBusinessCenterEnum var1);

        public BusinessCentersBuilder addBusinessCenter(FieldWithMetaBusinessCenterEnum var1, int var2);

        public BusinessCentersBuilder addBusinessCenterValue(BusinessCenterEnum var1);

        public BusinessCentersBuilder addBusinessCenterValue(BusinessCenterEnum var1, int var2);

        public BusinessCentersBuilder addBusinessCenter(List<? extends FieldWithMetaBusinessCenterEnum> var1);

        public BusinessCentersBuilder setBusinessCenter(List<? extends FieldWithMetaBusinessCenterEnum> var1);

        public BusinessCentersBuilder addBusinessCenterValue(List<? extends BusinessCenterEnum> var1);

        public BusinessCentersBuilder setBusinessCenterValue(List<? extends BusinessCenterEnum> var1);

        public BusinessCentersBuilder addCommodityBusinessCalendar(FieldWithMetaCommodityBusinessCalendarEnum var1);

        public BusinessCentersBuilder addCommodityBusinessCalendar(FieldWithMetaCommodityBusinessCalendarEnum var1, int var2);

        public BusinessCentersBuilder addCommodityBusinessCalendarValue(CommodityBusinessCalendarEnum var1);

        public BusinessCentersBuilder addCommodityBusinessCalendarValue(CommodityBusinessCalendarEnum var1, int var2);

        public BusinessCentersBuilder addCommodityBusinessCalendar(List<? extends FieldWithMetaCommodityBusinessCalendarEnum> var1);

        public BusinessCentersBuilder setCommodityBusinessCalendar(List<? extends FieldWithMetaCommodityBusinessCalendarEnum> var1);

        public BusinessCentersBuilder addCommodityBusinessCalendarValue(List<? extends CommodityBusinessCalendarEnum> var1);

        public BusinessCentersBuilder setCommodityBusinessCalendarValue(List<? extends CommodityBusinessCalendarEnum> var1);

        public BusinessCentersBuilder setBusinessCentersReference(ReferenceWithMetaBusinessCenters var1);

        public BusinessCentersBuilder setBusinessCentersReferenceValue(BusinessCenters var1);

        public BusinessCentersBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("businessCenter"), processor, FieldWithMetaBusinessCenterEnum.FieldWithMetaBusinessCenterEnumBuilder.class, this.getBusinessCenter(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityBusinessCalendar"), processor, FieldWithMetaCommodityBusinessCalendarEnum.FieldWithMetaCommodityBusinessCalendarEnumBuilder.class, this.getCommodityBusinessCalendar(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessCentersReference"), processor, ReferenceWithMetaBusinessCenters.ReferenceWithMetaBusinessCentersBuilder.class, this.getBusinessCentersReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        public BusinessCentersBuilder prune();
    }
}

