# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['CollateralInterestHandlingParameters']


class CollateralInterestHandlingParameters(BaseDataClass):
  """
  Represents parameters that describe how calculated interest amounts are handled, i.e. are they transferred/distributed, or is the collateral balance adjusted, is netting done, and any other special handling.
  """
  interestPaymentHandling: CollateralInterestHandlingEnum = Field(..., description="Specifies how the collateral interest is to be handled.")
  """
  Specifies how the collateral interest is to be handled.
  """
  paymentBusinessCenter: List[BusinessCenterEnum] = Field([], description="Specifies applicable business centers for payments.")
  """
  Specifies applicable business centers for payments.
  """
  netPostedAndHeldInterest: bool = Field(..., description="Indicates whether to net Held and Posted Interest Payments (i.e. whether interest payable for a period can be netted with interest receivable).")
  """
  Indicates whether to net Held and Posted Interest Payments (i.e. whether interest payable for a period can be netted with interest receivable).
  """
  netInterestWithMarginCalls: bool = Field(..., description="Indicates whether the interest amount may be offset against any margin call deliver or return amounts? (aka 'net payments' indicator).")
  """
  Indicates whether the interest amount may be offset against any margin call deliver or return amounts?   (aka 'net payments' indicator).
  """
  includeAccrualInMarginCalc: bool = Field(..., description="Indicates whether or not to include the open interest accrual in the margin calculation.")
  """
  Indicates whether or not to include the open interest accrual in the margin calculation.
  """
  accrueInterestOnUnsettledInterest: Optional[bool] = Field(None, description="Indicates whether interest accruing on unsettled interest amount is included (continues to be accrued) in the following period.")
  """
  Indicates whether interest accruing on unsettled interest amount is included (continues to be accrued) in the following period.
  """
  onFullReturn: bool = Field(..., description="Indicates the option that accrued interest should be calculated and distributed when a full return of collateral occurs.")
  """
  Indicates the option that accrued interest should be calculated and distributed when a full return of collateral occurs.
  """
  onPartialReturn: bool = Field(..., description="Indicates the option that accrued interest should be calculated and distributed when a partial return collateral occurs.")
  """
  Indicates the option that accrued interest should be calculated and distributed when a partial return collateral occurs.
  """
  interestAmountApplication: Optional[InterestAmountApplication] = Field(None, description="The application of Interest Amount with respect to the Delivery Amount and the Return Amount.")
  """
  The application of Interest Amount with respect to the Delivery Amount and the Return Amount.
  """
  interestRolloverLimit: Optional[NumberBound] = Field(None, description="Specifies the level below which the interest will be rolled over.")
  """
  Specifies the level below which the interest will be rolled over.
  """
  writeoffLimit: Optional[NumberBound] = Field(None, description="Specifies the level below which the interest will be written off; if omitted write-off is not applicable.")
  """
  Specifies the level below which the interest will be written off; if omitted write-off is not applicable.
  """
  alternativeToInterestAmount: Optional[AlternativeToInterestAmountEnum] = Field(None, description="Specifies the alternative to interest amounts.")
  """
  Specifies the alternative to interest amounts.
  """
  alternativeProvision: Optional[str] = Field(None, description="Specifies an alternative to interest amount, when the alternative provision clause is specified.")
  """
  Specifies an alternative to interest amount, when the alternative provision clause is specified.
  """
  cutoffTime: Optional[time] = Field(None, description="Specifies the time of day that interest needs to be confirmed by.")
  """
  Specifies the time of day that interest needs to be confirmed by.
  """
  notification: Optional[CollateralInterestNotification] = Field(None, description="Specifies the terms describing notification requirements.")
  """
  Specifies the terms describing notification requirements.
  """
  
  @rosetta_condition
  def condition_0_Alternative(self):
    def _then_fn0():
      return ((_resolve_rosetta_attr(self, "alternativeProvision")) is not None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(all_elements(_resolve_rosetta_attr(self, "alternativeToInterestAmount"), "=", _resolve_rosetta_attr(AlternativeToInterestAmountEnum, "OTHER")), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_1_Alternative2(self):
    def _then_fn0():
      return ((_resolve_rosetta_attr(self, "alternativeProvision")) is None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(any_elements(_resolve_rosetta_attr(self, "alternativeToInterestAmount"), "<>", _resolve_rosetta_attr(AlternativeToInterestAmountEnum, "OTHER")), _then_fn0, _else_fn0)

from cdm.product.collateral.CollateralInterestHandlingEnum import CollateralInterestHandlingEnum
from cdm.base.datetime.BusinessCenterEnum import BusinessCenterEnum
from cdm.product.collateral.InterestAmountApplication import InterestAmountApplication
from cdm.base.math.NumberBound import NumberBound
from cdm.product.collateral.AlternativeToInterestAmountEnum import AlternativeToInterestAmountEnum
from cdm.product.collateral.CollateralInterestNotification import CollateralInterestNotification

CollateralInterestHandlingParameters.update_forward_refs()
