# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['CalculationScheduleDeliveryPeriods']

from cdm.product.asset.AssetDeliveryPeriods import AssetDeliveryPeriods

class CalculationScheduleDeliveryPeriods(AssetDeliveryPeriods):
  """
  Period and time profile over which the delivery takes place.
  """
  deliveryCapacity: Optional[Quantity] = Field(None, description="The number of units included in the transaction for each delivery interval")
  """
  The number of units included in the transaction for each delivery interval
  """
  priceTimeIntervalQuantity: Optional[Price] = Field(None, description="Price per quantity per delivery time interval.")
  """
  Price per quantity per delivery time interval.
  """

from cdm.base.math.Quantity import Quantity
from cdm.observable.asset.Price import Price

CalculationScheduleDeliveryPeriods.update_forward_refs()
