# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['ContractBase']


class ContractBase(BaseDataClass):
  """
  Encapsulates data features common to trade and position.
  """
  contractDetails: Optional[AttributeWithReference | ContractDetails] = Field(None, description="Represents information specific to trades or positions involving contractual products.")
  """
  Represents information specific to trades or positions involving contractual products.
  """
  executionDetails: Optional[AttributeWithReference | ExecutionDetails] = Field(None, description="Defines specific attributes that relate to trade or position executions.")
  """
  Defines specific attributes that relate to trade or position executions.
  """
  collateral: Optional[AttributeWithReference | Collateral] = Field(None, description="Represents the collateral obligations of a party.")
  """
  Represents the collateral obligations of a party.
  """

from cdm.event.common.ContractDetails import ContractDetails
from cdm.event.common.ExecutionDetails import ExecutionDetails
from cdm.product.collateral.Collateral import Collateral

ContractBase.update_forward_refs()
