# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['LocationIdentifier']

from cdm.base.staticdata.identifier.Identifier import Identifier

class LocationIdentifier(Identifier):
  """
  Specifies a location identifier. An issuer and an identifier type can be associated with the actual identifier value as a way to properly qualify it.
  """
  locationIdentifierType: Optional[CommodityLocationIdentifierTypeEnum] = Field(None, description="Specifies the nature of a location identifier.")
  """
  Specifies the nature of a location identifier.
  """
  
  @rosetta_condition
  def condition_0_IdentifierType(self):
    """
    The element specifying the nature of a location identifier can only be applied to a single identifier.
    """
    def _then_fn0():
      return all_elements(len(_resolve_rosetta_attr(self, "assignedIdentifier")), "=", 1)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(self, "locationIdentifierType")) is not None), _then_fn0, _else_fn0)

from cdm.base.staticdata.identifier.CommodityLocationIdentifierTypeEnum import CommodityLocationIdentifierTypeEnum

LocationIdentifier.update_forward_refs()
