package cdm.product.template.validation;

import cdm.product.template.MandatoryEarlyTerminationAdjustedDates;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class MandatoryEarlyTerminationAdjustedDatesTypeFormatValidator implements Validator<MandatoryEarlyTerminationAdjustedDates> {

	@Override
	public ValidationResult<MandatoryEarlyTerminationAdjustedDates> validate(RosettaPath path, MandatoryEarlyTerminationAdjustedDates o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("MandatoryEarlyTerminationAdjustedDates", ValidationType.TYPE_FORMAT, "MandatoryEarlyTerminationAdjustedDates", path, "", error);
		}
		return success("MandatoryEarlyTerminationAdjustedDates", ValidationType.TYPE_FORMAT, "MandatoryEarlyTerminationAdjustedDates", path, "");
	}

}
