package cdm.product.template.validation;

import cdm.product.template.InitialMarginCalculation;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class InitialMarginCalculationTypeFormatValidator implements Validator<InitialMarginCalculation> {

	@Override
	public ValidationResult<InitialMarginCalculation> validate(RosettaPath path, InitialMarginCalculation o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("InitialMarginCalculation", ValidationType.TYPE_FORMAT, "InitialMarginCalculation", path, "", error);
		}
		return success("InitialMarginCalculation", ValidationType.TYPE_FORMAT, "InitialMarginCalculation", path, "");
	}

}
