package cdm.product.template.validation;

import cdm.product.template.EarlyTerminationEvent;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class EarlyTerminationEventTypeFormatValidator implements Validator<EarlyTerminationEvent> {

	@Override
	public ValidationResult<EarlyTerminationEvent> validate(RosettaPath path, EarlyTerminationEvent o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("EarlyTerminationEvent", ValidationType.TYPE_FORMAT, "EarlyTerminationEvent", path, "", error);
		}
		return success("EarlyTerminationEvent", ValidationType.TYPE_FORMAT, "EarlyTerminationEvent", path, "");
	}

}
