package cdm.product.template.validation;

import cdm.product.template.Asian;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class AsianTypeFormatValidator implements Validator<Asian> {

	@Override
	public ValidationResult<Asian> validate(RosettaPath path, Asian o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("Asian", ValidationType.TYPE_FORMAT, "Asian", path, "", error);
		}
		return success("Asian", ValidationType.TYPE_FORMAT, "Asian", path, "");
	}

}
