package cdm.product.template.functions;

import cdm.base.math.CompareOp;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.functions.CompareNumbers;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CompareTradeLotToAmount.CompareTradeLotToAmountDefault.class)
public abstract class CompareTradeLotToAmount implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected CompareNumbers compareNumbers;

	/**
	* @param tradeLot 
	* @param op 
	* @param amount 
	* @return result 
	*/
	public Boolean evaluate(TradeLot tradeLot, CompareOp op, BigDecimal amount) {
		Boolean result = doEvaluate(tradeLot, op, amount);
		
		return result;
	}

	protected abstract Boolean doEvaluate(TradeLot tradeLot, CompareOp op, BigDecimal amount);

	public static class CompareTradeLotToAmountDefault extends CompareTradeLotToAmount {
		@Override
		protected Boolean doEvaluate(TradeLot tradeLot, CompareOp op, BigDecimal amount) {
			Boolean result = null;
			return assignOutput(result, tradeLot, op, amount);
		}
		
		protected Boolean assignOutput(Boolean result, TradeLot tradeLot, CompareOp op, BigDecimal amount) {
			result = MapperS.of(tradeLot).<PriceQuantity>mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).<NonNegativeQuantitySchedule>map("getValue", _f->_f.getValue())
				.filterItemNullSafe(item -> (Boolean)exists(item.<BigDecimal>map("getValue", measureBase -> measureBase.getValue())).get())
				.apply(item -> areEqual(item
					.mapItem(_item -> (MapperS<Boolean>)MapperS.of(compareNumbers.evaluate(_item.<BigDecimal>map("getValue", measureBase -> measureBase.getValue()).get(), MapperS.of(op).get(), MapperS.of(amount).get()))), MapperS.of(Boolean.valueOf(true)), CardinalityOperator.All).asMapper()).get();
			
			return result;
		}
	}
}
