package cdm.product.common.schedule.validation;

import cdm.product.common.schedule.DateRelativeToCalculationPeriodDates;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class DateRelativeToCalculationPeriodDatesTypeFormatValidator implements Validator<DateRelativeToCalculationPeriodDates> {

	@Override
	public ValidationResult<DateRelativeToCalculationPeriodDates> validate(RosettaPath path, DateRelativeToCalculationPeriodDates o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("DateRelativeToCalculationPeriodDates", ValidationType.TYPE_FORMAT, "DateRelativeToCalculationPeriodDates", path, "", error);
		}
		return success("DateRelativeToCalculationPeriodDates", ValidationType.TYPE_FORMAT, "DateRelativeToCalculationPeriodDates", path, "");
	}

}
