package cdm.product.collateral.validation;

import cdm.product.collateral.CollateralValuationTreatment;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CollateralValuationTreatmentValidator implements Validator<CollateralValuationTreatment> {

	@Override
	public ValidationResult<CollateralValuationTreatment> validate(RosettaPath path, CollateralValuationTreatment o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("haircutPercentage", (BigDecimal) o.getHaircutPercentage() != null ? 1 : 0, 0, 1), 
				checkCardinality("marginPercentage", (BigDecimal) o.getMarginPercentage() != null ? 1 : 0, 0, 1), 
				checkCardinality("fxHaircutPercentage", (BigDecimal) o.getFxHaircutPercentage() != null ? 1 : 0, 0, 1), 
				checkCardinality("additionalHaircutPercentage", (BigDecimal) o.getAdditionalHaircutPercentage() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CollateralValuationTreatment", ValidationType.CARDINALITY, "CollateralValuationTreatment", path, "", error);
		}
		return success("CollateralValuationTreatment", ValidationType.CARDINALITY, "CollateralValuationTreatment", path, "");
	}

}
