package cdm.product.asset.validation.exists;

import cdm.product.asset.AdditionalFixedPayments;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class AdditionalFixedPaymentsOnlyExistsValidator implements ValidatorWithArg<AdditionalFixedPayments, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends AdditionalFixedPayments> ValidationResult<AdditionalFixedPayments> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("interestShortfallReimbursement", ExistenceChecker.isSet((Boolean) o.getInterestShortfallReimbursement()))
				.put("principalShortfallReimbursement", ExistenceChecker.isSet((Boolean) o.getPrincipalShortfallReimbursement()))
				.put("writedownReimbursement", ExistenceChecker.isSet((Boolean) o.getWritedownReimbursement()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("AdditionalFixedPayments", ValidationType.ONLY_EXISTS, "AdditionalFixedPayments", path, "");
		}
		return failure("AdditionalFixedPayments", ValidationType.ONLY_EXISTS, "AdditionalFixedPayments", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
