package cdm.product.asset.validation.datarule;

import cdm.product.asset.ReturnTermsBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.0.0
 */
@RosettaDataRule("ReturnTermsBasePositiveExpectedN")
@ImplementedBy(ReturnTermsBasePositiveExpectedN.Default.class)
public interface ReturnTermsBasePositiveExpectedN extends Validator<ReturnTermsBase> {
	
	String NAME = "ReturnTermsBasePositiveExpectedN";
	String DEFINITION = "expectedN > 0";
	
	ValidationResult<ReturnTermsBase> validate(RosettaPath path, ReturnTermsBase returnTermsBase);
	
	class Default implements ReturnTermsBasePositiveExpectedN {
	
		@Override
		public ValidationResult<ReturnTermsBase> validate(RosettaPath path, ReturnTermsBase returnTermsBase) {
			ComparisonResult result = executeDataRule(returnTermsBase);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ReturnTermsBase", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null) {
				failureMessage = "Condition " + NAME + " failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "ReturnTermsBase", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(ReturnTermsBase returnTermsBase) {
			try {
				ComparisonResult result = greaterThan(MapperS.of(returnTermsBase).<Integer>map("getExpectedN", _returnTermsBase -> _returnTermsBase.getExpectedN()), MapperS.of(Integer.valueOf(0)), CardinalityOperator.All);
				return result.get() == null ? ComparisonResult.success() : result;
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ReturnTermsBasePositiveExpectedN {
	
		@Override
		public ValidationResult<ReturnTermsBase> validate(RosettaPath path, ReturnTermsBase returnTermsBase) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ReturnTermsBase", path, DEFINITION);
		}
	}
}
