package cdm.product.asset.validation;

import cdm.product.asset.FloatingAmountEvents;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class FloatingAmountEventsTypeFormatValidator implements Validator<FloatingAmountEvents> {

	@Override
	public ValidationResult<FloatingAmountEvents> validate(RosettaPath path, FloatingAmountEvents o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("FloatingAmountEvents", ValidationType.TYPE_FORMAT, "FloatingAmountEvents", path, "", error);
		}
		return success("FloatingAmountEvents", ValidationType.TYPE_FORMAT, "FloatingAmountEvents", path, "");
	}

}
