package cdm.product.asset.validation;

import cdm.product.asset.CashflowRepresentation;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CashflowRepresentationValidator implements Validator<CashflowRepresentation> {

	@Override
	public ValidationResult<CashflowRepresentation> validate(RosettaPath path, CashflowRepresentation o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("cashflowsMatchParameters", (Boolean) o.getCashflowsMatchParameters() != null ? 1 : 0, 1, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CashflowRepresentation", ValidationType.CARDINALITY, "CashflowRepresentation", path, "", error);
		}
		return success("CashflowRepresentation", ValidationType.CARDINALITY, "CashflowRepresentation", path, "");
	}

}
