package cdm.product.asset.validation;

import cdm.product.asset.AssetDeliveryProfile;
import cdm.product.asset.BankHolidayTreatmentEnum;
import cdm.product.asset.LoadTypeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class AssetDeliveryProfileValidator implements Validator<AssetDeliveryProfile> {

	@Override
	public ValidationResult<AssetDeliveryProfile> validate(RosettaPath path, AssetDeliveryProfile o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("loadType", (LoadTypeEnum) o.getLoadType() != null ? 1 : 0, 0, 1), 
				checkCardinality("bankHolidaysTreatment", (BankHolidayTreatmentEnum) o.getBankHolidaysTreatment() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("AssetDeliveryProfile", ValidationType.CARDINALITY, "AssetDeliveryProfile", path, "", error);
		}
		return success("AssetDeliveryProfile", ValidationType.CARDINALITY, "AssetDeliveryProfile", path, "");
	}

}
