package cdm.observable.asset.validation;

import cdm.base.staticdata.party.AncillaryEntity;
import cdm.base.staticdata.party.ReferenceBanks;
import cdm.observable.asset.FxSpotRateSource;
import cdm.observable.asset.SettlementRateOption;
import cdm.observable.asset.ValuationSource;
import cdm.observable.asset.metafields.ReferenceWithMetaQuotedCurrencyPair;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class ValuationSourceValidator implements Validator<ValuationSource> {

	@Override
	public ValidationResult<ValuationSource> validate(RosettaPath path, ValuationSource o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("quotedCurrencyPair", (ReferenceWithMetaQuotedCurrencyPair) o.getQuotedCurrencyPair() != null ? 1 : 0, 0, 1), 
				checkCardinality("informationSource", (FxSpotRateSource) o.getInformationSource() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementRateOption", (SettlementRateOption) o.getSettlementRateOption() != null ? 1 : 0, 0, 1), 
				checkCardinality("referenceBanks", (ReferenceBanks) o.getReferenceBanks() != null ? 1 : 0, 0, 1), 
				checkCardinality("dealerOrCCP", (AncillaryEntity) o.getDealerOrCCP() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("ValuationSource", ValidationType.CARDINALITY, "ValuationSource", path, "", error);
		}
		return success("ValuationSource", ValidationType.CARDINALITY, "ValuationSource", path, "");
	}

}
