package cdm.observable.asset.validation;

import cdm.observable.asset.FxRateObservable;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class FxRateObservableTypeFormatValidator implements Validator<FxRateObservable> {

	@Override
	public ValidationResult<FxRateObservable> validate(RosettaPath path, FxRateObservable o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("FxRateObservable", ValidationType.TYPE_FORMAT, "FxRateObservable", path, "", error);
		}
		return success("FxRateObservable", ValidationType.TYPE_FORMAT, "FxRateObservable", path, "");
	}

}
