package cdm.observable.asset.validation;

import cdm.base.staticdata.asset.common.Equity;
import cdm.observable.asset.BondChoiceModel;
import cdm.observable.asset.BondEquityModel;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class BondEquityModelValidator implements Validator<BondEquityModel> {

	@Override
	public ValidationResult<BondEquityModel> validate(RosettaPath path, BondEquityModel o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("bondchoiceModel", (BondChoiceModel) o.getBondchoiceModel() != null ? 1 : 0, 0, 1), 
				checkCardinality("equity", (Equity) o.getEquity() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("BondEquityModel", ValidationType.CARDINALITY, "BondEquityModel", path, "", error);
		}
		return success("BondEquityModel", ValidationType.CARDINALITY, "BondEquityModel", path, "");
	}

}
