package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.functions.DateDifference;
import cdm.base.datetime.functions.PopOffDateList;
import cdm.base.math.functions.AppendToVector;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GenerateWeights.GenerateWeightsDefault.class)
public abstract class GenerateWeights implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected AppendToVector appendToVector;
	@Inject protected DateDifference dateDifference;
	@Inject protected cdm.observable.asset.calculatedrate.functions.GenerateWeights generateWeights;
	@Inject protected PopOffDateList popOffDateList;

	/**
	* @param weightingDates A list of dates for which weightings are require.
	* @return weights A vector of weights, typically numbers between 1 and 3.
	*/
	public List<BigDecimal> evaluate(List<Date> weightingDates) {
		List<BigDecimal> weights = doEvaluate(weightingDates);
		
		return weights;
	}

	protected abstract List<BigDecimal> doEvaluate(List<Date> weightingDates);

	protected abstract Mapper<Boolean> active(List<Date> weightingDates);

	protected abstract Mapper<Date> refDate(List<Date> weightingDates);

	protected abstract Mapper<Date> remainingDates(List<Date> weightingDates);

	protected abstract Mapper<Date> prevDate(List<Date> weightingDates);

	protected abstract Mapper<Integer> diff(List<Date> weightingDates);

	protected abstract Mapper<BigDecimal> remainingWeights(List<Date> weightingDates);

	public static class GenerateWeightsDefault extends GenerateWeights {
		@Override
		protected List<BigDecimal> doEvaluate(List<Date> weightingDates) {
			List<BigDecimal> weights = new ArrayList<>();
			return assignOutput(weights, weightingDates);
		}
		
		protected List<BigDecimal> assignOutput(List<BigDecimal> weights, List<Date> weightingDates) {
			List<BigDecimal> addVar = MapperUtils.runMulti(() -> {
				if (MapperS.of(active(weightingDates).get()).getOrDefault(false)) {
					return MapperC.<BigDecimal>of(appendToVector.evaluate(MapperC.<BigDecimal>of(remainingWeights(weightingDates).getMulti()).getMulti(), MapperMaths.<BigDecimal, Integer, BigDecimal>multiply(MapperS.of(diff(weightingDates).get()), MapperS.of(new BigDecimal("1.0"))).get()));
				}
				else {
					return null;
				}
			}).getMulti();
			weights.addAll(addVar);
			
			return weights;
		}
		
		@Override
		protected Mapper<Boolean> active(List<Date> weightingDates) {
			return greaterThan(MapperS.of(MapperC.<Date>of(weightingDates).resultCount()), MapperS.of(Integer.valueOf(1)), CardinalityOperator.All);
		}
		
		@Override
		protected Mapper<Date> refDate(List<Date> weightingDates) {
			return MapperC.<Date>of(weightingDates)
				.last();
		}
		
		@Override
		protected Mapper<Date> remainingDates(List<Date> weightingDates) {
			return MapperC.<Date>of(popOffDateList.evaluate(MapperC.<Date>of(weightingDates).getMulti()));
		}
		
		@Override
		protected Mapper<Date> prevDate(List<Date> weightingDates) {
			return MapperC.<Date>of(remainingDates(weightingDates).getMulti())
				.last();
		}
		
		@Override
		protected Mapper<Integer> diff(List<Date> weightingDates) {
			return MapperS.of(dateDifference.evaluate(MapperS.of(prevDate(weightingDates).get()).get(), MapperS.of(refDate(weightingDates).get()).get()));
		}
		
		@Override
		protected Mapper<BigDecimal> remainingWeights(List<Date> weightingDates) {
			return MapperC.<BigDecimal>of(generateWeights.evaluate(MapperC.<Date>of(remainingDates(weightingDates).getMulti()).getMulti()));
		}
	}
}
