package cdm.legaldocumentation.master.validation;

import cdm.legaldocumentation.master.Clause;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class ClauseValidator implements Validator<Clause> {

	@Override
	public ValidationResult<Clause> validate(RosettaPath path, Clause o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("identifier", (String) o.getIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("terms", (String) o.getTerms() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("Clause", ValidationType.CARDINALITY, "Clause", path, "", error);
		}
		return success("Clause", ValidationType.CARDINALITY, "Clause", path, "");
	}

}
