package cdm.legaldocumentation.common.validation;

import cdm.legaldocumentation.common.LegalAgreementBase;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class LegalAgreementBaseTypeFormatValidator implements Validator<LegalAgreementBase> {

	@Override
	public ValidationResult<LegalAgreementBase> validate(RosettaPath path, LegalAgreementBase o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("LegalAgreementBase", ValidationType.TYPE_FORMAT, "LegalAgreementBase", path, "", error);
		}
		return success("LegalAgreementBase", ValidationType.TYPE_FORMAT, "LegalAgreementBase", path, "");
	}

}
