package cdm.event.common.validation;

import cdm.base.staticdata.party.Party;
import cdm.event.common.BillingRecord;
import cdm.event.common.BillingSummary;
import cdm.event.common.SecurityLendingInvoice;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class SecurityLendingInvoiceValidator implements Validator<SecurityLendingInvoice> {

	@Override
	public ValidationResult<SecurityLendingInvoice> validate(RosettaPath path, SecurityLendingInvoice o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("sendingParty", (Party) o.getSendingParty() != null ? 1 : 0, 1, 1), 
				checkCardinality("receivingParty", (Party) o.getReceivingParty() != null ? 1 : 0, 1, 1), 
				checkCardinality("billingStartDate", (Date) o.getBillingStartDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("billingEndDate", (Date) o.getBillingEndDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("billingRecord", (List<? extends BillingRecord>) o.getBillingRecord() == null ? 0 : ((List<? extends BillingRecord>) o.getBillingRecord()).size(), 1, 0), 
				checkCardinality("billingSummary", (List<? extends BillingSummary>) o.getBillingSummary() == null ? 0 : ((List<? extends BillingSummary>) o.getBillingSummary()).size(), 1, 0)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("SecurityLendingInvoice", ValidationType.CARDINALITY, "SecurityLendingInvoice", path, "", error);
		}
		return success("SecurityLendingInvoice", ValidationType.CARDINALITY, "SecurityLendingInvoice", path, "");
	}

}
